/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class FreePortFinder {
    private final int minPortNumber;
    private final int portRange;
    private final Set<Integer> selectedPorts = new HashSet<Integer>();
    private final Random random = new Random();

    public FreePortFinder(int minPortNumber, int maxPortNumber) {
        this.minPortNumber = minPortNumber;
        this.portRange = maxPortNumber - minPortNumber;
    }

    public synchronized Integer find() {
        for (int i = 0; i < this.portRange; ++i) {
            int port = this.minPortNumber + this.random.nextInt(this.portRange);
            if (this.selectedPorts.contains(port) || !this.isPortFree(port)) continue;
            this.selectedPorts.add(port);
            return port;
        }
        throw new IllegalStateException("Unable to find an available port");
    }

    public synchronized void releasePort(int port) {
        if (this.isPortFree(port)) {
            this.selectedPorts.remove(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPortFree(int port) {
        boolean portIsFree = true;
        ServerSocket server = null;
        try {
            server = new ServerSocket(port);
            server.setReuseAddress(true);
        }
        catch (IOException e) {
            portIsFree = false;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException e) {}
            }
        }
        return portIsFree;
    }
}

