/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.api.model;

import java.util.Objects;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;


/**
 * <p>
 * An abstract model that represents the Attributes of a Mule Event
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class EventAttributes {

  @Parameter
  @Placement(order = 1)
  private Object value = new NullObject();

  @Optional
  @Example("application/java")
  @Placement(order = 2)
  @Parameter
  protected String mediaType;

  @Optional
  @Example("UTF-8")
  @Placement(order = 3)
  @Parameter
  protected String encoding;

  public Object getValue() {
    return value;
  }

  public void setValue(Object value) {
    this.value = value;
  }

  public String getMediaType() {
    return mediaType;
  }

  public void setMediaType(String mediaType) {
    this.mediaType = mediaType;
  }

  public String getEncoding() {
    return encoding;
  }

  public void setEncoding(String encoding) {
    this.encoding = encoding;
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof EventAttributes)) {
      return false;

    } else if (object == this) {
      return true;
    }

    EventAttributes that = (EventAttributes) object;

    return Objects.equals(this.getValue(), that.getValue()) &&
        Objects.equals(this.getMediaType(), that.getMediaType()) &&
        Objects.equals(this.getEncoding(), that.getEncoding());
  }

  @Override
  public int hashCode() {
    return Objects.hash(getValue(), getMediaType(), getEncoding());
  }
}
