/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.internal.matchers;



import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.mule.runtime.api.metadata.TypedValue;

/**
 * A Hamcrest matchers to perform assertions for typed values
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public abstract class TypedValueMatcher extends BaseMatcher<TypedValue> {

  @Override
  public boolean matches(Object o) {
    TypedValue typedValue = (TypedValue) o;
    return doMatch(typedValue);
  }

  public abstract boolean doMatch(TypedValue typedValue);

  /**
   * Returns the same matcher but for any object instead of just {@link TypedValue}
   *
   * @return The Hamcrest Matcher that compares to any object
   */
  public abstract Matcher<Object> toPlainValueMatcher();
}

