/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.api.matchers;

import static org.mule.munit.assertion.internal.util.Preconditions.checkArgument;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * <p>
 * Matcher used in the assert-that operation.
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class Matcher {

  private String type = "default";
  private Object[] expected;


  public Object[] getExpected() {
    return expected;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    checkArgument(isNotBlank(type), "The type must not be null nor empty");
    this.type = type;
  }

  public void setExpected(Object[] expected) {
    checkArgument(expected != null, "Expected must not be null");
    this.expected = expected;
  }
}
