/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.assertion.internal.matchers;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.mule.munit.assertion.internal.matchers.TypedValueMatcher;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class MediaTypeMatcher
extends TypedValueMatcher {
    private MediaType mediaType;

    public MediaTypeMatcher(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public boolean doMatch(TypedValue typedValue) {
        if (this.mediaType == null) {
            return CoreMatchers.nullValue().matches((Object)typedValue.getDataType().getMediaType());
        }
        return this.mediaType.matches(typedValue.getDataType().getMediaType());
    }

    public void describeMismatch(Object item, Description description) {
        super.describeMismatch((Object)this.getDescription(((TypedValue)item).getDataType().getMediaType()), description);
    }

    public void describeTo(Description description) {
        if (this.mediaType == null) {
            CoreMatchers.nullValue().describeTo(description);
            return;
        }
        description.appendText(this.getDescription(this.mediaType));
    }

    private String getDescription(MediaType mediaType) {
        return mediaType.withoutParameters().toRfcString();
    }

    @Override
    public Matcher<Object> toPlainValueMatcher() {
        throw new IllegalStateException("Media Type Matcher cannot be compared to a value");
    }
}

