/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.internal.matchers;

import com.google.common.collect.Lists;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.mule.runtime.api.metadata.TypedValue;

import java.util.Iterator;


/**
 * A ValueMatcher used only for collections matchers
 *
 * @since 2.1.0
 * @author Mulesoft Inc.
 */
public class IterableMatcher extends ValueMatcher {

  private TypedValue valueToBeMatched;

  public IterableMatcher(Matcher<? extends Iterable<?>> nestedMatcher) {
    super(nestedMatcher);
  }

  @Override
  public boolean doMatch(TypedValue typedValue) {
    valueToBeMatched = escapeIterator(typedValue);
    return super.doMatch(valueToBeMatched);
  }

  @Override
  public void describeMismatch(Object item, Description description) {
    super.describeMismatch(valueToBeMatched, description);
  }

  private TypedValue escapeIterator(TypedValue typedValue) {
    if (!(typedValue.getValue() instanceof Iterator)) {
      return typedValue;
    }
    Iterator iterator = (Iterator) typedValue.getValue();
    return TypedValue.of(Lists.newArrayList(iterator));
  }

}
