/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.api.matchers;

import static com.google.common.base.Preconditions.checkArgument;

import java.util.List;

/**
 * Model to represent result of a DW comparison
 *
 * @since 2.0.0
 * @author Mulesoft Inc.
 */
public class Diff {

  private Boolean matches;
  private List<Difference> diffs;

  public Diff() {}

  public Diff(Boolean matches, List<Difference> diffs) {
    checkArgument(matches != null, "Matches must not be null");
    checkArgument(diffs != null, "Validations must not be null");
    this.matches = matches;
    this.diffs = diffs;
  }

  public Boolean getMatches() {
    return matches;
  }

  public void setMatches(Boolean matches) {
    checkArgument(matches != null, "Matches must not be null");
    this.matches = matches;
  }

  public List<Difference> getDiffs() {
    return diffs;
  }

  public void setDiffs(List<Difference> diffs) {
    checkArgument(diffs != null, "Validations must not be null");
    this.diffs = diffs;
  }

  /**
   * Model representing a comparison
   *
   * @since 2.1.0
   * @author Mulesoft Inc.
   */
  public static class Difference {

    private String expected;
    private String actual;
    private String path;

    public String getExpected() {
      return expected;
    }

    public void setExpected(String expected) {
      checkArgument(expected != null, "Expected must not be null");
      this.expected = expected;
    }

    public void setActual(String actual) {
      checkArgument(actual != null, "Actual must not be null");
      this.actual = actual;
    }

    public String getActual() {
      return actual;
    }

    public String getPath() {
      return path;
    }

    public void setPath(String path) {
      this.path = path;
    }

    public String getActualWithLocation() {
      return actual + " at " + path;
    }
  }

  @Override
  public String toString() {
    return "matches: " + matches + ", differences=" + diffs;
  }
}
