/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.assertion.internal.matchers;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.mule.munit.assertion.api.matchers.Diff;
import org.mule.munit.assertion.internal.matchers.TypedValueMatcher;
import org.mule.runtime.api.metadata.TypedValue;

public class CallbackMatcher
extends TypedValueMatcher {
    private Function<List<Object>, Diff> callback;
    private Diff result;

    public CallbackMatcher(Function<List<Object>, Diff> callback) {
        this.callback = callback;
    }

    @Override
    public boolean doMatch(TypedValue typedValue) {
        this.result = this.callback.apply(Collections.singletonList(typedValue));
        return this.result.getMatches();
    }

    public void describeTo(Description description) {
        this.assumeNullIfResultNotPresent();
        description.appendText(this.messageToString(this.result.getDiffs().stream().map(Diff.Difference::getExpected).collect(Collectors.toList())));
    }

    public void describeMismatch(Object item, Description description) {
        this.assumeNullIfResultNotPresent();
        description.appendText(this.messageToString(this.result.getDiffs().stream().map(Diff.Difference::getActualWithLocation).collect(Collectors.toList())));
    }

    private void assumeNullIfResultNotPresent() {
        if (this.result == null) {
            this.doMatch(TypedValue.of(null));
        }
    }

    @Override
    public Matcher<Object> toPlainValueMatcher() {
        return new BaseMatcher<Object>(){

            public boolean matches(Object o) {
                return CallbackMatcher.this.doMatch(TypedValue.of((Object)o));
            }

            public void describeTo(Description description) {
                CallbackMatcher.this.describeTo(description);
            }

            public void describeMismatch(Object item, Description description) {
                CallbackMatcher.this.describeMismatch(item, description);
            }
        };
    }

    private String messageToString(List<String> messages) {
        return messages.stream().collect(Collectors.joining(","));
    }
}

