/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.processors;

import org.apache.commons.lang.StringUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.munit.assertion.AssertModule;
import org.mule.munit.common.adapters.MuleMessageDataTypeSetterAdapter;
import org.mule.munit.common.model.Property;
import org.mule.transformer.types.SimpleDataType;
import org.mule.transport.NullPayload;

import java.util.ArrayList;
import java.util.List;


/**
 * <p>
 * Sets the payload
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class SetMessageProcessor extends MunitMessageProcessor {

    private Object payload;
    private String mimeType;
    private String encoding;

    private List<Property> invocationProperties;
    private List<Property> inboundProperties;
    private List<Property> sessionProperties;
    private List<Property> outboundProperties;


    @Override
    protected void doProcess(MuleMessage mulemessage, AssertModule module) {
        DefaultMuleMessage defaultMuleMessage = (DefaultMuleMessage) mulemessage;

        setProperties(defaultMuleMessage, inboundProperties, PropertyScope.INBOUND);
        setProperties(defaultMuleMessage, invocationProperties, PropertyScope.INVOCATION);
        setProperties(defaultMuleMessage, outboundProperties, PropertyScope.OUTBOUND);
        setProperties(defaultMuleMessage, sessionProperties, PropertyScope.SESSION);

        Object evaluatedPayload = evaluate(mulemessage, payload);
        DataType dataType = resolveDataType(evaluatedPayload, mimeType, encoding);

        new MuleMessageDataTypeSetterAdapter(defaultMuleMessage).setPayload(evaluatedPayload, dataType);
    }

    private List<Property> setProperties(DefaultMuleMessage message, List<Property> properties, PropertyScope scope) {
        List<Property> evaluatedMap = new ArrayList<Property>();
        if (properties != null) {
            for (Property property : properties) {
                Object value = evaluate(message, property.getValue());
                DataType dataType = resolveDataType(value, property.getMimeType(), property.getEncoding());

                new MuleMessageDataTypeSetterAdapter(message).setProperty(property.getKey(), value, scope, dataType);
            }
        }

        return evaluatedMap;
    }


    @Override
    protected String getProcessor() {
        return "set";
    }

    public void setPayload(Object value) {
        this.payload = value;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }


    public void setInvocationProperties(List<Property> invocationProperties) {
        this.invocationProperties = invocationProperties;
    }

    public void setInboundProperties(List<Property> inboundProperties) {
        this.inboundProperties = inboundProperties;
    }

    public void setSessionProperties(List<Property> sessionProperties) {
        this.sessionProperties = sessionProperties;
    }

    public void setOutboundProperties(List<Property> outboundProperties) {
        this.outboundProperties = outboundProperties;
    }

    private DataType resolveDataType(Object value, String mimeType, String encoding) {
        Class type = (value == null || value instanceof NullPayload) ? Object.class : value.getClass();

        String realMimeType = StringUtils.isEmpty(mimeType) ? null : mimeType;

        SimpleDataType simpleDataType = new SimpleDataType(type, realMimeType);
        simpleDataType.setEncoding(encoding);

        return simpleDataType;
    }
}
