/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.processors;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.munit.assertion.MunitAssertion;
import org.mule.munit.common.exception.MunitError;


/**
 * <p>
 * Message processor that runs the custom assertion
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class RunAssertionMessageProcessor implements MessageProcessor
{

    /**
     * <p>
     * The assertion to be run.
     * </p>
     */
    private MunitAssertion assertion;


    @Override
    public MuleEvent process(MuleEvent event) throws MuleException
    {
        if(null == assertion)
        {
            throw new MunitError("The munit:run-custom MP assertion requires a class implementing org.mule.munit.assertion.MunitAssertion. Please provide one.");
        }
        return assertion.execute(event);
    }

    public void setAssertion(MunitAssertion assertion)
    {
        this.assertion = assertion;
    }
}
