/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.mel.utils;

import org.mule.api.MuleContext;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageFunction;
import org.mule.munit.assertion.utils.ScriptableRunner;


/**
 * <p>
 * MEL function that executes an script to get a payload
 * <p/>
 * usage:
 * <p/>
 * <pre>
 *         {@code
 *
 *           <script:script name="mockPayload" engine="groovy"><![CDATA[
 *                       return new String("anotherString");
 *                 ]]>
 *           </script:script>
 *
 *           <mock:verify-call messageProcessor="jira:create-group" atLeast="1">
 *                   <mock:attributes>
 *                           <mock:attribute name="userName" whereValue-ref='#[resultOfScript(mockPayload)]'/>
 *                   </mock:attributes>
 *           </mock:verify-call>
 *         }
 *     </pre>
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class FlowResultFunction implements ExpressionLanguageFunction {
    private MuleContext muleContext;
    private ScriptableRunner scriptableRunner;

    public FlowResultFunction() {
        this.scriptableRunner = new ScriptableRunner();
    }


    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setScriptableRunner(ScriptableRunner scriptableRunner){
        this.scriptableRunner = scriptableRunner;
    }

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context) {
        if (params != null && params.length > 0 && params[0] instanceof String) {
            String scriptName = (String) params[0];

            return scriptableRunner.run(scriptName, muleContext);
        }
        throw new IllegalArgumentException("The script name references a non script component, make sure the script is written as in " +
                "http://www.mulesoft.org/documentation/display/MULE3USER/Scripting+Module+Reference ");
    }

}
