/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.config;

import org.mule.munit.api.spring.config.parsers.MunitGenericDefinitionParser;
import org.mule.munit.api.spring.config.parsers.MunitOrphanDefinitionParser;
import org.mule.munit.api.spring.config.parsers.model.ListChildElement;
import org.mule.munit.api.spring.config.parsers.model.MapChildElement;
import org.mule.munit.api.spring.config.parsers.model.ParseableElement;
import org.mule.munit.assertion.AssertModule;
import org.mule.munit.assertion.processors.*;
import org.mule.munit.assertion.spring.config.AbstractAssertModuleNamespaceHandler;
import org.mule.munit.common.endpoint.MunitSpringFactoryPostProcessor;
import org.mule.munit.common.model.Property;

import static org.mule.munit.api.spring.config.parsers.MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder;
import static org.mule.munit.api.spring.config.parsers.MunitOrphanDefinitionParser.MunitOrphanDefinitionParserBuilder;

/**
 * <p>
 * Assert Module Namespace Handler
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class AssertModuleNamespaceHandler extends AbstractAssertModuleNamespaceHandler {

    protected void declareBeanDefinitionParsers() {
        declareBeanDefinitionParser("config", buildAssertModuleDefinitionParser());
        declareBeanDefinitionParser("assert-payload-equals", buildAssertPayloadEqualsDefinitionParser());
        declareBeanDefinitionParser("assert-true", buildAssertTrueDefinitionParser());
        declareBeanDefinitionParser("assert-on-equals", buildAssertOnEqualsDefinitionParser());
        declareBeanDefinitionParser("assert-not-same", buildAssertNotSameDefinitionParser());
        declareBeanDefinitionParser("assert-false", buildAssertFalseDefinitionParser());
        declareBeanDefinitionParser("assert-not-null", buildAssertNotNullDefinitionParser());
        declareBeanDefinitionParser("assert-null", buildAssertNullDefinitionParser());
        declareBeanDefinitionParser("set", buildSetDefinitionParser());
        declareBeanDefinitionParser("run-custom", buildRunCustomDefinitionParser());
        declareBeanDefinitionParser("set-null-payload", buildSetNullPayloadDefinitionParser());
        declareBeanDefinitionParser("fail", buildFailDefinitionParser());
        declareBeanDefinitionParser("test", buildTestDefinitionParser());
        declareBeanDefinitionParser("before-test", buildBeforeTestDefinitionParser());
        declareBeanDefinitionParser("after-test", buildAfterTestDefinitionParser());
        declareBeanDefinitionParser("before-suite", buildBeforeSuiteDefinitionParser());
        declareBeanDefinitionParser("after-suite", buildAfterSuiteDefinitionParser());
    }

    private MunitGenericDefinitionParser buildAssertModuleDefinitionParser() {
        MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParserBuilder(AssertModule.class);
        builder = builder.withScope("singleton")
                .withElementAttribute("name", MunitSpringFactoryPostProcessor.MUNIT_FACTORY_POST_PROCESSOR_ID)
                .withAttribute("mock-inbounds", "mockInbounds")
                .withAttribute("mock-connectors", "mockConnectors")
                .withChildElement("exclude-inbound-mocking", new ListChildElement.ListChildElementBuilder("exclude-inbound-mocking", "mockingExcludedFlows").withItemClass(String.class).withItemName("flow-name").build())
                .withNoAttachProcessorDefinition();

        return builder.build();
    }

    private MunitGenericDefinitionParser buildAssertPayloadEqualsDefinitionParser() {
        MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParserBuilder(AssertThatMessageProcessor.class);
        builder = builder.withScope("prototype")
                .withAttribute("message", "message")
                .withAttribute("expectedValue", "expectedValue");

        return builder.build();
    }

    private MunitGenericDefinitionParser buildAssertTrueDefinitionParser() {
        MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParserBuilder(AssertTrueMessageProcessor.class);
        builder = builder.withScope("prototype")
                .withAttribute("message", "message")
                .withAttribute("condition", "condition");

        return builder.build();
    }

    private MunitGenericDefinitionParser buildAssertOnEqualsDefinitionParser() {
        MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParserBuilder(AssertOnEqualsMessageProcessor.class);
        builder = builder.withScope("prototype")
                .withAttribute("message", "message")
                .withAttribute("expectedValue", "expectedValue")
                .withAttribute("actualValue", "actualValue");

        return builder.build();
    }

    private MunitGenericDefinitionParser buildAssertNotSameDefinitionParser() {
        MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParserBuilder(AssertNotSameMessageProcessor.class);
        builder = builder.withScope("prototype")
                .withAttribute("message", "message")
                .withAttribute("expectedValue", "expectedValue")
                .withAttribute("actualValue", "actualValue");

        return builder.build();
    }

    private MunitGenericDefinitionParser buildAssertFalseDefinitionParser() {
        MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParserBuilder(AssertFalseMessageProcessor.class);
        builder = builder.withScope("prototype")
                .withAttribute("message", "message")
                .withAttribute("condition", "condition");

        return builder.build();
    }

    private MunitGenericDefinitionParser buildAssertNotNullDefinitionParser() {
        MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParserBuilder(AssertNotNullMessageProcessor.class);
        builder = builder.withScope("prototype")
                .withAttribute("message", "message");

        return builder.build();
    }

    private MunitGenericDefinitionParser buildAssertNullDefinitionParser() {
        MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParserBuilder(AssertNullMessageProcessor.class);
        builder = builder.withScope("prototype")
                .withAttribute("message", "message");

        return builder.build();
    }

    private MunitGenericDefinitionParser buildSetDefinitionParser() {
        MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParserBuilder(SetMessageProcessor.class);
        builder = builder.withScope("prototype")
                .withAttribute("payload", "payload")
                .withAttribute("mimeType", "mimeType")
                .withAttribute("encoding", "encoding")
                .withChildElement("invocation-properties", buildPropertiesListlement("invocation-properties", "invocationProperties", "invocation-property"))
                .withChildElement("inbound-properties", buildPropertiesListlement("inbound-properties", "inboundProperties", "inbound-property"))
                .withChildElement("session-properties", buildPropertiesListlement("session-properties", "sessionProperties", "session-property"))
                .withChildElement("outbound-properties", buildPropertiesListlement("outbound-properties", "outboundProperties", "outbound-property"));
        return builder.build();
    }

    private MunitGenericDefinitionParser buildRunCustomDefinitionParser() {
        MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParserBuilder(RunAssertionMessageProcessor.class);
        builder = builder.withScope("prototype")
                .withAttribute("assertion-ref", "assertion");

        return builder.build();
    }

    private MunitGenericDefinitionParser buildSetNullPayloadDefinitionParser() {
        MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParserBuilder(SetMessageProcessor.class);
        builder = builder.withScope("prototype")
                .withAttribute("payload", "payload");

        return builder.build();
    }

    private MunitGenericDefinitionParser buildFailDefinitionParser() {
        MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParserBuilder(FailMessageProcessor.class);
        builder = builder.withScope("prototype")
                .withAttribute("message", "message");

        return builder.build();
    }

    private MunitOrphanDefinitionParser buildTestDefinitionParser() {
        MunitOrphanDefinitionParserBuilder builder = new MunitOrphanDefinitionParserBuilder();

        builder = builder.withScope("singleton")
                .withMessageProcessorClass(MunitTestFlow.class)
                .withAttribute("expectException", "expectException")
                .withAttribute("ignore", "ignore");

        return builder.build();
    }

    private MunitOrphanDefinitionParser buildBeforeTestDefinitionParser() {
        MunitOrphanDefinitionParserBuilder builder = new MunitOrphanDefinitionParserBuilder();
        builder = builder.withScope("singleton")
                .withMessageProcessorClass(MunitBeforeTest.class);

        return builder.build();
    }

    private MunitOrphanDefinitionParser buildAfterTestDefinitionParser() {
        MunitOrphanDefinitionParserBuilder builder = new MunitOrphanDefinitionParserBuilder();
        builder = builder.withScope("singleton")
                .withMessageProcessorClass(MunitAfterTest.class);

        return builder.build();
    }

    private MunitOrphanDefinitionParser buildBeforeSuiteDefinitionParser() {
        MunitOrphanDefinitionParserBuilder builder = new MunitOrphanDefinitionParserBuilder();
        builder = builder.withScope("singleton")
                .withMessageProcessorClass(MunitBeforeSuite.class);

        return builder.build();
    }

    private MunitOrphanDefinitionParser buildAfterSuiteDefinitionParser() {
        MunitOrphanDefinitionParserBuilder builder = new MunitOrphanDefinitionParserBuilder();
        builder = builder.withScope("singleton")
                .withMessageProcessorClass(MunitAfterSuite.class);

        return builder.build();
    }

    private ParseableElement buildMapChildElement(String elementName, String elementPropertyName, String elementItemName) {
        MapChildElement.MapChildElementBuilder builder = new MapChildElement.MapChildElementBuilder(elementName, elementPropertyName);
        builder.withItemName(elementItemName);
        return builder.build();
    }

    private ParseableElement buildPropertiesListlement(String elementName, String elementPropertyName, String elementItemName) {
        ListChildElement.ListChildElementBuilder builder = new ListChildElement.ListChildElementBuilder(elementName, elementPropertyName);
        builder.withItemClass(Property.class)
                .withItemName(elementItemName)
                .withItemAttribute("key", "key")
                .withItemAttribute("value", "value")
                .withItemAttribute("mimeType", "mimeType")
                .withItemAttribute("encoding", "encoding");

        return builder.build();
    }

}
