/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.assertion.processors;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.munit.assertion.AssertModule;
import org.mule.munit.assertion.processors.MunitMessageProcessor;
import org.mule.munit.common.adapters.MuleMessageDataTypeSetterAdapter;
import org.mule.munit.common.model.Property;
import org.mule.transformer.types.SimpleDataType;
import org.mule.transport.NullPayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetMessageProcessor
extends MunitMessageProcessor {
    private Object payload;
    private String mimeType;
    private String encoding;
    private List<Property> invocationProperties;
    private List<Property> inboundProperties;
    private List<Property> sessionProperties;
    private List<Property> outboundProperties;

    @Override
    protected void doProcess(MuleMessage mulemessage, AssertModule module) {
        DefaultMuleMessage defaultMuleMessage = (DefaultMuleMessage)mulemessage;
        this.setProperties(defaultMuleMessage, this.inboundProperties, PropertyScope.INBOUND);
        this.setProperties(defaultMuleMessage, this.invocationProperties, PropertyScope.INVOCATION);
        this.setProperties(defaultMuleMessage, this.outboundProperties, PropertyScope.OUTBOUND);
        this.setProperties(defaultMuleMessage, this.sessionProperties, PropertyScope.SESSION);
        Object evaluatedPayload = this.evaluate(mulemessage, this.payload);
        DataType dataType = this.resolveDataType(evaluatedPayload, this.mimeType, this.encoding);
        new MuleMessageDataTypeSetterAdapter((MuleMessage)defaultMuleMessage).setPayload(evaluatedPayload, dataType);
    }

    private List<Property> setProperties(DefaultMuleMessage message, List<Property> properties, PropertyScope scope) {
        ArrayList<Property> evaluatedMap = new ArrayList<Property>();
        if (properties != null) {
            for (Property property : properties) {
                Object value = this.evaluate((MuleMessage)message, property.getValue());
                DataType dataType = this.resolveDataType(value, property.getMimeType(), property.getEncoding());
                new MuleMessageDataTypeSetterAdapter((MuleMessage)message).setProperty(property.getKey(), value, scope, dataType);
            }
        }
        return evaluatedMap;
    }

    @Override
    protected String getProcessor() {
        return "set";
    }

    public void setPayload(Object value) {
        this.payload = value;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setInvocationProperties(List<Property> invocationProperties) {
        this.invocationProperties = invocationProperties;
    }

    public void setInboundProperties(List<Property> inboundProperties) {
        this.inboundProperties = inboundProperties;
    }

    public void setSessionProperties(List<Property> sessionProperties) {
        this.sessionProperties = sessionProperties;
    }

    public void setOutboundProperties(List<Property> outboundProperties) {
        this.outboundProperties = outboundProperties;
    }

    private DataType resolveDataType(Object value, String mimeType, String encoding) {
        Class<Object> type = value == null || value instanceof NullPayload ? Object.class : value.getClass();
        String realMimeType = StringUtils.isEmpty((String)mimeType) ? null : mimeType;
        SimpleDataType simpleDataType = new SimpleDataType(type, realMimeType);
        simpleDataType.setEncoding(encoding);
        return simpleDataType;
    }
}

