/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq;

import com.mulesoft.mq.restclient.internal.DestinationLocation;
import com.mulesoft.mq.restclient.utils.UrlConversionUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class CourierUrlBuilder {
    private static final String DESTINATION_INSTANCE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s";
    private static final String FALLBACK_CONFIG_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/fallbackConfig";
    private static final String MESSAGE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages";
    private static final String MESSAGE_INSTANCE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages/%s";
    private static final String LOCK_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages/locks";
    private static final String LOCK_INSTANCE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages/%s/locks/%s";
    private final String baseUri;
    private String fallbackBaseUri;

    public CourierUrlBuilder(String baseUri, String fallbackBaseUri) {
        this.baseUri = baseUri;
        this.fallbackBaseUri = fallbackBaseUri;
    }

    public CourierUrlBuilder(String baseUri) {
        this(baseUri, null);
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String serviceRegistryUrl() {
        return this.serviceRegistryUrl(false);
    }

    public String serviceRegistryUrl(boolean useFallbackRegion) {
        String primaryRegionUrl = this.baseUri + "/serviceRegistry";
        if (useFallbackRegion) {
            return UrlConversionUtils.getDefaultFallbackRegionUrl(primaryRegionUrl);
        }
        return primaryRegionUrl;
    }

    public String encode(String idToBeEncoded, String encodingType) throws UnsupportedEncodingException {
        return URLEncoder.encode(idToBeEncoded, encodingType);
    }

    private String getFallbackBaseUriForDefaultRegion() {
        return UrlConversionUtils.getDefaultFallbackRegionUrl(this.baseUri);
    }

    private void initializeSelectedFallbackBaseUri(DestinationLocation destinationLocation) {
        if (this.fallbackBaseUri == null) {
            this.fallbackBaseUri = destinationLocation.getFallbackRegion().isPresent() ? UrlConversionUtils.getFallbackRegionUrl(this.baseUri, destinationLocation.getFallbackRegion().get()) : this.getFallbackBaseUriForDefaultRegion();
        }
    }

    public String fallbackConfig(DestinationLocation destinationLocation, boolean useFallbackDestination) {
        if (useFallbackDestination) {
            return String.format(FALLBACK_CONFIG_PATTERN, this.getFallbackBaseUriForDefaultRegion(), destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName() + "_fb");
        }
        return String.format(FALLBACK_CONFIG_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName());
    }

    public String messages(DestinationLocation destinationLocation) {
        return this.messages(destinationLocation, false);
    }

    public String messages(DestinationLocation destinationLocation, boolean useFallbackDestination) {
        if (useFallbackDestination) {
            this.initializeSelectedFallbackBaseUri(destinationLocation);
            return String.format(MESSAGE_PATTERN, this.fallbackBaseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getFallbackName());
        }
        return String.format(MESSAGE_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName());
    }

    public String message(DestinationLocation destinationLocation, String messageId) {
        return this.message(destinationLocation, messageId, false);
    }

    public String message(DestinationLocation destinationLocation, String messageId, boolean useFallbackDestination) {
        String encodedMessageId;
        try {
            encodedMessageId = this.encode(messageId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            encodedMessageId = "someMessageIdValue";
        }
        if (useFallbackDestination) {
            this.initializeSelectedFallbackBaseUri(destinationLocation);
            return String.format(MESSAGE_INSTANCE_PATTERN, this.fallbackBaseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getFallbackName(), encodedMessageId);
        }
        return String.format(MESSAGE_INSTANCE_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName(), encodedMessageId);
    }

    public String lock(DestinationLocation destinationLocation, String messageId, String lockId) {
        return this.lock(destinationLocation, messageId, lockId, false);
    }

    public String lock(DestinationLocation destinationLocation, String messageId, String lockId, boolean usedFallbackDestination) {
        String encodedMessageId;
        String encodedLockId;
        try {
            encodedLockId = this.encode(lockId, "UTF-8");
            encodedMessageId = this.encode(messageId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            encodedLockId = "ERROR";
            encodedMessageId = "someMessageIdValue";
        }
        if (usedFallbackDestination) {
            this.initializeSelectedFallbackBaseUri(destinationLocation);
            return String.format(LOCK_INSTANCE_PATTERN, this.fallbackBaseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getFallbackName(), encodedMessageId, encodedLockId);
        }
        return String.format(LOCK_INSTANCE_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName(), encodedMessageId, encodedLockId);
    }

    public String locks(DestinationLocation destinationLocation) {
        return this.locks(destinationLocation, false);
    }

    public String locks(DestinationLocation destinationLocation, boolean usedFallbackDestination) {
        if (usedFallbackDestination) {
            this.initializeSelectedFallbackBaseUri(destinationLocation);
            return String.format(LOCK_PATTERN, this.fallbackBaseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getFallbackName());
        }
        return String.format(LOCK_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName());
    }
}

