/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.utils.AnypointMQFallbackRegionMapping;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlConversionUtils {
    private static final String ANYPOINT_DOMAIN_DELIMITER = ".anypoint.mulesoft.com";
    protected static final Logger LOGGER = LoggerFactory.getLogger(UrlConversionUtils.class);

    public static String getFallbackRegionUrl(String primaryRegionUrl) {
        try {
            String withoutProtocol = new URI(primaryRegionUrl).toURL().getHost();
            int index = withoutProtocol.indexOf(ANYPOINT_DOMAIN_DELIMITER);
            if (index != -1) {
                String primaryRegion = withoutProtocol.substring(0, index);
                String fallbackRegion = AnypointMQFallbackRegionMapping.getFallbackRegionFromPrimary(primaryRegion);
                return fallbackRegion == null ? null : primaryRegionUrl.replace(primaryRegion, fallbackRegion);
            }
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Exception while trying to get fallback region for the primary region %s", primaryRegionUrl), (Throwable)e);
        }
        return null;
    }
}

