/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.exception;

import com.mulesoft.mq.restclient.client.Response;
import com.mulesoft.mq.restclient.exception.PayloadTooLargeException;
import com.mulesoft.mq.restclient.exception.ResourceNotFoundException;
import com.mulesoft.mq.restclient.exception.RestException;

public class ExceptionFactory {
    public static RestException create(String operation, Exception e) {
        return new RestException(ExceptionFactory.createExceptionMessage(operation, e.getMessage()), e, null);
    }

    public static RestException create(String operation, Response response, String message) {
        return ExceptionFactory.create(operation, response, message, null);
    }

    public static RestException create(String operation, Response response, String message, Exception cause) {
        if (response != null && response.getStatusCode() == 404) {
            return new ResourceNotFoundException(ExceptionFactory.createExceptionMessage(operation, message), cause, response);
        }
        if (response != null && response.getStatusCode() == 413) {
            return new PayloadTooLargeException(message, cause, response);
        }
        return new RestException(ExceptionFactory.createExceptionMessage(operation, message), cause, response);
    }

    private static String createExceptionMessage(String operation, String message) {
        return String.format("An error occurred while executing the operation: %s. Cause: %s.", operation, message != null ? message : "-");
    }
}

