/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq.domain;

import com.google.common.base.Preconditions;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultAnypointMQMessage
implements AnypointMQMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAnypointMQMessage.class);
    private final InputStream body;
    private final Map<String, Object> headers;
    private final Map<String, Object> properties;

    public DefaultAnypointMQMessage(InputStream body, Map<String, Object> headers, Map<String, Object> properties) {
        Preconditions.checkArgument((headers != null ? 1 : 0) != 0, (Object)"Headers map cannot be null");
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)"Properties map cannot be null");
        this.body = body;
        this.headers = headers;
        this.properties = properties;
    }

    @Override
    public String getMessageId() {
        return (String)this.headers.get("messageId");
    }

    @Override
    public String getLockId() {
        return (String)this.headers.get("lockId");
    }

    @Override
    public int getDeliveryCount() {
        String deliveryCount = (String)this.headers.get("deliveryCount");
        if (deliveryCount == null || deliveryCount.trim().isEmpty()) {
            return 1;
        }
        try {
            return Integer.parseInt(deliveryCount);
        }
        catch (NumberFormatException nfe) {
            LOGGER.debug("Failed to read message '{}' header, using default instead. Received value was: {}", (Object)"deliveryCount", (Object)deliveryCount);
            return 1;
        }
    }

    @Override
    public Optional<Integer> getDeliveryDelay() {
        if (this.headers.get("deliveryDelay") == null) {
            return Optional.empty();
        }
        return Optional.of((Integer)this.headers.get("deliveryDelay"));
    }

    @Override
    public InputStream getBody() {
        return this.body;
    }

    @Override
    public Optional<String> getMessageGroupId() {
        if (this.headers.get("messageGroupId") == null) {
            return Optional.empty();
        }
        return Optional.of((String)this.headers.get("messageGroupId"));
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String getBodyAsString() {
        try {
            return IOUtils.toString((InputStream)this.body, (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Message body cannot be converted to string:" + e.getMessage(), e);
        }
    }

    @Override
    public String getContentType() {
        return (String)this.properties.get("contentType");
    }
}

