/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal.circuit;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.mulesoft.mq.restclient.api.circuit.CircuitTestingLock;
import com.mulesoft.mq.restclient.api.circuit.MQCircuitBreaker;
import com.mulesoft.mq.restclient.internal.circuit.ReentrantCircuitTestLock;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCircuitBreaker
implements MQCircuitBreaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCircuitBreaker.class);
    private final String circuitName;
    private final long tripTimeout;
    private final int errorsThreshold;
    private final String errorsWhitelist;
    private final Stopwatch openTimeWatch;
    private final Predicate<String> errorMatcher;
    private final AtomicInteger failureCount = new AtomicInteger(0);
    private final CircuitTestingLock circuitLock = new ReentrantCircuitTestLock();
    private MQCircuitBreaker.CircuitState state;

    public DefaultCircuitBreaker(String circuitName, String errorTypes, int errorsThreshold, long tripTimeout, TimeUnit tripTimeoutUnit) {
        Preconditions.checkArgument((errorsThreshold > 0 ? 1 : 0) != 0, (Object)String.format("Errors threshold must be greater or equal to one, but Circuit Breaker was configured with a '%s' errors limit", errorsThreshold));
        Preconditions.checkArgument((tripTimeoutUnit.toMillis(tripTimeout) >= 1000L ? 1 : 0) != 0, (Object)String.format("Trip timeout has to be at least one second, but Circuit Breaker was configured with tripTimeout of '%s' MILLIS", tripTimeoutUnit.toMillis(tripTimeout)));
        this.circuitName = circuitName;
        this.errorsWhitelist = errorTypes;
        this.errorMatcher = this.createErrorMatcher(errorTypes);
        this.errorsThreshold = errorsThreshold;
        this.tripTimeout = TimeUnit.MILLISECONDS.convert(tripTimeout, tripTimeoutUnit);
        this.openTimeWatch = Stopwatch.createUnstarted();
        this.state = MQCircuitBreaker.CircuitState.CLOSED;
    }

    @Override
    public void onSuccess() {
        if (!this.isOpen()) {
            this.closeCircuit();
        }
    }

    @Override
    public MQCircuitBreaker.CircuitState onFailure(String errorType) {
        if (this.errorMatcher.test(errorType)) {
            if (this.failureCount.incrementAndGet() >= this.errorsThreshold && !this.isOpen()) {
                this.openCircuit();
            }
            LOGGER.debug("State after failure: " + this.state.name());
        }
        return this.state;
    }

    @Override
    public MQCircuitBreaker.CircuitState getState() {
        if (MQCircuitBreaker.CircuitState.OPEN == this.state && this.tripTimeHasEvicted()) {
            this.state = MQCircuitBreaker.CircuitState.HALF_OPEN;
        }
        return this.state;
    }

    @Override
    public boolean acquireCircuitLock() {
        boolean acquired = this.isHalfOpen() && this.circuitLock.acquire();
        LOGGER.debug("Attempting to acquire circuit '{}' testing lock. Acquired: {}", (Object)this.circuitName, (Object)acquired);
        return acquired;
    }

    @Override
    public boolean awaitCircuitLock(int circuitLockTTL) throws InterruptedException {
        return this.circuitLock.await(circuitLockTTL);
    }

    @Override
    public boolean releaseCircuitLock() {
        boolean release = this.circuitLock.release();
        LOGGER.debug("Attempting to release circuit '{}' testing lock. Acquired: {}", (Object)this.circuitName, (Object)release);
        return release;
    }

    private boolean tripTimeHasEvicted() {
        boolean running = this.openTimeWatch.isRunning();
        long elapsed = this.openTimeWatch.elapsed(TimeUnit.MILLISECONDS);
        LOGGER.debug("ELAPSED TIME {} expected {} ", (Object)elapsed, (Object)this.tripTimeout);
        return running && elapsed >= this.tripTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openCircuit() {
        Stopwatch stopwatch = this.openTimeWatch;
        synchronized (stopwatch) {
            if (MQCircuitBreaker.CircuitState.CLOSED.equals((Object)this.state) || MQCircuitBreaker.CircuitState.HALF_OPEN.equals((Object)this.state)) {
                this.openTimeWatch.reset();
                this.openTimeWatch.start();
                this.circuitLock.release();
                this.state = MQCircuitBreaker.CircuitState.OPEN;
                LOGGER.debug("Circuit '{}' tripped, moving to OPEN", (Object)this.circuitName);
            }
        }
    }

    private void closeCircuit() {
        if (this.isHalfOpen()) {
            LOGGER.debug("Circuit '{}' recovered, moving to CLOSED", (Object)this.circuitName);
        }
        this.state = MQCircuitBreaker.CircuitState.CLOSED;
        this.circuitLock.release();
        this.failureCount.set(0);
        this.openTimeWatch.reset();
    }

    private Predicate<String> createErrorMatcher(String errorTypes) {
        return errorTypes != null && !errorTypes.trim().isEmpty() ? errorTypes::contains : e -> true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCircuitBreaker that = (DefaultCircuitBreaker)o;
        return this.tripTimeout == that.tripTimeout && this.errorsThreshold == that.errorsThreshold && Objects.equals(this.circuitName, that.circuitName) && Objects.equals(this.errorsWhitelist, that.errorsWhitelist);
    }

    public int hashCode() {
        return Objects.hash(this.circuitName, this.tripTimeout, this.errorsThreshold, this.errorsWhitelist);
    }
}

