/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.impl;

import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.AnypointMqMessageBuilder;
import com.mulesoft.mq.restclient.api.CourierObservable;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.DestinationLocation;
import com.mulesoft.mq.restclient.api.LockedMessage;
import com.mulesoft.mq.restclient.api.MessageIdResult;
import com.mulesoft.mq.restclient.impl.DefaultCourierObservable;
import com.mulesoft.mq.restclient.internal.CourierRestClient;
import com.mulesoft.mq.restclient.internal.LockId;
import com.mulesoft.mq.restclient.internal.NewTtl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultDestination
implements Destination {
    private final CourierRestClient client;
    private final DestinationLocation destinationLocation;

    public DefaultDestination(CourierRestClient client, DestinationLocation destinationLocation) {
        this.client = client;
        this.destinationLocation = destinationLocation;
    }

    @Override
    public String getName() {
        return this.destinationLocation.getName();
    }

    public DefaultCourierObservable<MessageIdResult> send(AnypointMqMessage message) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.send(this.destinationLocation, message));
    }

    public DefaultCourierObservable<List<MessageIdResult>> send(List<AnypointMqMessage> messages) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.send(this.destinationLocation, messages));
    }

    public DefaultCourierObservable<List<AnypointMqMessage>> receive() {
        return this.receive(1, 0L, 120000L);
    }

    public DefaultCourierObservable<List<AnypointMqMessage>> receive(int batchSize, long poolingTime, long lockTtl) {
        return new DefaultCourierObservable<List<AnypointMqMessage>>(this.client.receive(this.destinationLocation, batchSize, poolingTime, lockTtl));
    }

    public DefaultCourierObservable<List<MessageIdResult>> ack(List<AnypointMqMessage> messages) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.ack(this.destinationLocation, this.asLockIds(messages)));
    }

    @Override
    public CourierObservable<MessageIdResult> ack(AnypointMqMessage message) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.ack(this.destinationLocation, this.asLockId(message)));
    }

    public DefaultCourierObservable<List<MessageIdResult>> nack(List<AnypointMqMessage> messages) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.nack(this.destinationLocation, this.asLockIds(messages)));
    }

    @Override
    public CourierObservable<MessageIdResult> nack(AnypointMqMessage message) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.nack(this.destinationLocation, this.asLockId(message)));
    }

    private List<LockId> asLockIds(List<AnypointMqMessage> messages) {
        return messages.stream().map(this::asLockId).collect(Collectors.toList());
    }

    private LockId asLockId(AnypointMqMessage message) {
        return new LockId(message.getId(), message.getLockId());
    }

    public DefaultCourierObservable<List<MessageIdResult>> modifyLockInterval(List<AnypointMqMessage> messages, int lockInterval) {
        ArrayList<NewTtl> newTtls = new ArrayList<NewTtl>();
        for (AnypointMqMessage message : messages) {
            newTtls.add(new NewTtl(message.getId(), message.getLockId(), lockInterval));
        }
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.modifyTtl(this.destinationLocation, newTtls));
    }

    public DefaultCourierObservable<List<MessageIdResult>> modifyLockInterval(List<LockedMessage> lockedMessages) {
        ArrayList<NewTtl> newTtls = new ArrayList<NewTtl>();
        for (LockedMessage lockedMessage : lockedMessages) {
            newTtls.add(new NewTtl(lockedMessage.getMessage().getId(), lockedMessage.getMessage().getLockId(), lockedMessage.getLockInterval()));
        }
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.modifyTtl(this.destinationLocation, newTtls));
    }

    @Override
    public AnypointMqMessageBuilder newMessageBuilder() {
        return new AnypointMqMessageBuilder();
    }
}

