/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.plugin.manager;

import com.mulesoft.mule.runtime.plugin.ManagedMulePlugin;
import com.mulesoft.mule.runtime.plugin.discoverer.PluginDiscoverer;
import com.mulesoft.mule.runtime.plugin.factory.PluginFactory;
import com.mulesoft.mule.runtime.plugin.factory.ServerPluginDescriptor;
import com.mulesoft.mule.runtime.plugin.manager.MulePluginManager;
import com.mulesoft.mule.runtime.plugin.manager.PluginManagerFactory;
import com.mulesoft.mule.runtime.plugin.processor.PluginProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulePluginManagerFactory
implements PluginManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(MulePluginManagerFactory.class);
    private final PluginDiscoverer pluginDiscoverer;
    private final PluginFactory pluginFactory;
    private PluginProcessor pluginProcessor;

    public MulePluginManagerFactory(PluginDiscoverer pluginDiscoverer, PluginFactory pluginFactory) {
        this.pluginDiscoverer = pluginDiscoverer;
        this.pluginFactory = pluginFactory;
    }

    @Override
    public MulePluginManager create() {
        logger.debug("Creating Server Plugins...");
        MulePluginManager pluginManager = new MulePluginManager();
        pluginManager.setPluginProcessor(this.pluginProcessor);
        for (ServerPluginDescriptor descriptor : this.pluginDiscoverer.discover()) {
            try {
                ManagedMulePlugin plugin = this.pluginFactory.create(descriptor);
                pluginManager.registerPlugin(plugin);
            }
            catch (Throwable e) {
                logger.error("Cannot create server plugin '{}', it will be disabled", (Object)descriptor.getName(), (Object)e);
            }
        }
        return pluginManager;
    }

    public void setPluginProcessor(PluginProcessor pluginProcessor) {
        this.pluginProcessor = pluginProcessor;
    }
}

