/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.cache.internal.http;

import com.mulesoft.mule.runtime.cache.api.CachingStrategy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.cache.CacheStorage;
import org.codehaus.httpcache4j.cache.HTTPCache;
import org.codehaus.httpcache4j.cache.MemoryCacheStorage;
import org.codehaus.httpcache4j.payload.ByteArrayPayload;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.resolver.ResponseResolver;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCachingStrategy
implements CachingStrategy {
    public static final String HTTP_CALLBACK_PROPERTY_KEY = "mule.httpcache.invoker";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private MuleContext muleContext;
    private CacheStorage cacheStorage = new MemoryCacheStorage();
    private ResponseResolver responseResolver = new MuleEventResponseResolver();
    private HTTPCache cache = new HTTPCache(this.cacheStorage, this.responseResolver);
    private String name;

    @Override
    public CoreEvent process(CoreEvent request, Processor messageProcessor) throws MuleException {
        HTTPRequest httpRequest = this.createHttpRequest(request);
        request = this.setHttpCacheCallback(request, messageProcessor);
        HTTPResponse httpResponse = this.cache.execute(httpRequest);
        httpResponse.consume();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("CACHE STATISTICS hitRatio: %s hits: %s misses: %s ", this.cache.getStatistics().getHitRatio(), this.cache.getStatistics().getHits(), this.cache.getStatistics().getMisses()));
        }
        return this.createResponseEvent(request, httpResponse);
    }

    private CoreEvent setHttpCacheCallback(CoreEvent request, Processor messageProcessor) {
        return CoreEvent.builder((CoreEvent)request).addVariable(HTTP_CALLBACK_PROPERTY_KEY, () -> messageProcessor.process(request)).build();
    }

    private HTTPRequest createHttpRequest(CoreEvent request) {
        Message message = request.getMessage();
        HttpRequestAttributes httpRequestAttributes = (HttpRequestAttributes)message.getAttributes().getValue();
        String extraRequestUri = httpRequestAttributes.getRequestUri();
        String baseRequestUri = String.valueOf(httpRequestAttributes.getScheme()) + "://" + (String)httpRequestAttributes.getHeaders().get((Object)"host") + httpRequestAttributes.getRequestUri();
        String requestUri = String.valueOf(baseRequestUri) + "/" + extraRequestUri;
        HTTPMethod httpMethod = this.getHttpMethod(request);
        HTTPRequest httpRequest = new HTTPRequest(requestUri, httpMethod);
        for (Map.Entry headerEntry : httpRequestAttributes.getHeaders().entrySet()) {
            String value = (String)headerEntry.getValue();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding header: " + (String)headerEntry.getKey() + " Value: " + value);
            }
            httpRequest = httpRequest.addHeader((String)headerEntry.getKey(), value);
        }
        return httpRequest;
    }

    private CoreEvent createResponseEvent(CoreEvent request, HTTPResponse httpResponse) {
        MultiMap properties = new MultiMap();
        Headers headers = httpResponse.getHeaders();
        for (String headerName : headers.keySet()) {
            properties.put((Object)headerName, (Object)headers.getFirstHeader(headerName).getValue());
        }
        Message resultMessage = Message.builder().value((Object)httpResponse.getPayload().getInputStream()).attributesValue((Object)new HttpResponseAttributes(httpResponse.getStatus().getCode(), httpResponse.getStatusLine().getMessage(), properties)).build();
        return CoreEvent.builder((CoreEvent)request).message(resultMessage).build();
    }

    private HTTPMethod getHttpMethod(CoreEvent event) {
        return HTTPMethod.valueOf((String)((HttpRequestAttributes)event.getMessage().getAttributes().getValue()).getMethod());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private class MuleEventResponseResolver
    implements ResponseResolver {
        private MuleEventResponseResolver() {
        }

        public HTTPResponse resolve(HTTPRequest httpRequest) throws IOException {
            if (HttpCachingStrategy.this.logger.isDebugEnabled()) {
                HttpCachingStrategy.this.logger.debug("Processing request: " + httpRequest);
            }
            try {
                PrivilegedEvent event = PrivilegedEvent.getCurrentEvent();
                Callable muleInvoker = (Callable)((TypedValue)event.getVariables().get(HttpCachingStrategy.HTTP_CALLBACK_PROPERTY_KEY)).getValue();
                CoreEvent response = (CoreEvent)muleInvoker.call();
                Message responseMessage = response.getMessage();
                ByteArrayPayload payload = new ByteArrayPayload((InputStream)new ByteArrayInputStream((byte[])HttpCachingStrategy.this.muleContext.getTransformationService().transform(responseMessage, DataType.STRING).getPayload().getValue()), MIMEType.valueOf((String)responseMessage.getPayload().getDataType().getMediaType().toRfcString()));
                HttpResponseAttributes httpResponseAttributes = (HttpResponseAttributes)responseMessage.getAttributes().getValue();
                Status status = Status.valueOf((int)httpResponseAttributes.getStatusCode());
                Headers headers = new Headers();
                for (Map.Entry headerEntry : httpResponseAttributes.getHeaders().entrySet()) {
                    String value = (String)headerEntry.getValue();
                    if (HttpCachingStrategy.this.logger.isDebugEnabled()) {
                        HttpCachingStrategy.this.logger.debug("Adding header: " + (String)headerEntry.getKey() + " Value: " + value);
                    }
                    headers = headers.set((String)headerEntry.getKey(), value);
                }
                return new HTTPResponse((Payload)payload, status, headers);
            }
            catch (Exception e) {
                IOException iox = new IOException("Can't process HTTP request with Mule");
                iox.initCause(e);
                throw iox;
            }
        }

        public void shutdown() {
        }
    }
}

