/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.reboot.license;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.LicenseManagementFactory;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseBootstrapConfigurer;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;

public class LicenseInstallBootstrapConfigurer
extends LicenseBootstrapConfigurer {
    private final Path keyRequestFile;

    public LicenseInstallBootstrapConfigurer(Logger bootstrapLogger, Path keyRequestFile) {
        super(bootstrapLogger);
        this.keyRequestFile = keyRequestFile;
    }

    @Override
    protected boolean doConfigure() throws LicenseException {
        EnterpriseLicenseKey key;
        File keyRequest = this.keyRequestFile.toFile();
        if (!keyRequest.exists()) {
            throw new LicenseException("Couldn't install license key!", new IOException(String.format("License key file - %s not found!", this.keyRequestFile)));
        }
        try {
            key = LicenseManagementFactory.getInstance().createLicenseKey("mule-ee");
        }
        catch (LicenseKeyException e) {
            throw new LicenseException("Couldn't install license key!", e);
        }
        key.setLicenseKeyFile(this.keyRequestFile.toString());
        EnterpriseLicenseKey newKey = this.createLicenseKeyHandler().install(key);
        this.moveLicenseKeyFileToMuleBaseConf(this.lookupMuleBaseConf());
        try {
            Files.delete(Paths.get(key.getLicenseKeyFile(), new String[0]));
        }
        catch (IOException e) {
            this.getBootstrapLogger().error("Couldn't delete source license file", (Throwable)e);
        }
        this.getBootstrapLogger().info(String.format("Installed license key --> %s", newKey));
        return false;
    }

    public Path getKeyRequestFile() {
        return this.keyRequestFile;
    }
}

