/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.reboot.license;

import com.mulesoft.mule.runtime.module.reboot.license.BouncyCastleProviderScope;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseBootstrapConfigurer;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseException;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseProviderException;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseVerificationException;
import org.mule.runtime.module.boot.internal.BootstrapConfigurationException;
import org.slf4j.Logger;

public abstract class AbstractLicenseVerifyBootstrapConfigurer
extends LicenseBootstrapConfigurer {
    public static final String BOUNCY_CASTLE_NOT_FOUND_WARNING = "Bouncy Castle libraries not found in lib/boot/. Only non-FIPS licenses can be verified. Copy Bouncy Castle FIPS libraries to lib/boot/ to verify FIPS licenses.";
    public static final String LICENSE_VERIFICATION_FAILED_NO_BC_FOUND_MESSAGE = "License verification failed. This may be a FIPS license that requires Bouncy Castle libraries in lib/boot/. Original error: ";

    public AbstractLicenseVerifyBootstrapConfigurer(Logger bootstrapLogger) {
        super(bootstrapLogger);
    }

    @Override
    public final boolean configure() throws BootstrapConfigurationException {
        try {
            return this.doConfigure();
        }
        catch (LicenseVerificationException e) {
            throw new BootstrapConfigurationException(1, (Throwable)e);
        }
        catch (LicenseException e) {
            throw new BootstrapConfigurationException(1, e.getCause());
        }
        catch (Exception e) {
            throw new BootstrapConfigurationException(1, (Throwable)e);
        }
    }

    @Override
    protected final boolean doConfigure() throws LicenseException {
        if (!BouncyCastleProviderScope.isBcAvailable()) {
            this.getBootstrapLogger().warn(BOUNCY_CASTLE_NOT_FOUND_WARNING);
        }
        try (BouncyCastleProviderScope bcProviderScope = BouncyCastleProviderScope.createWithInjectedProviders();){
            this.getBootstrapLogger().debug("Injected Bouncy Castle providers for license verification");
            this.performLicenseVerification();
        }
        catch (LicenseProviderException e) {
            this.getBootstrapLogger().debug("Failed to inject security providers, falling back to original method: {}", (Object)e.getMessage());
            this.performLicenseVerification();
        }
        catch (LicenseException e) {
            if (!BouncyCastleProviderScope.isBcAvailable()) {
                throw new LicenseVerificationException(LICENSE_VERIFICATION_FAILED_NO_BC_FOUND_MESSAGE + e.getMessage(), e.getCause());
            }
            throw e;
        }
        return false;
    }

    protected abstract void performLicenseVerification() throws LicenseException;

    protected <T> void logLicenseDetails(T validate) {
        if (this.getBootstrapLogger().isInfoEnabled()) {
            String msg = "Valid license key --> " + String.valueOf(validate);
            this.getBootstrapLogger().info(msg);
        }
    }
}

