/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.reboot;

import com.mulesoft.mule.runtime.module.reboot.FipsSecurityConfigurationException;
import com.mulesoft.mule.runtime.module.reboot.FipsSecurityManager;
import java.lang.reflect.Constructor;
import java.security.Provider;
import java.security.Security;

public class DefaultFipsSecurityManager
implements FipsSecurityManager {
    private static final String SYSTEM_PROPERTY_PREFIX = "mule.";
    private static final String MULE_SECURITY_PROVIDER_PROPERTY = "mule.security.provider";
    private static final String MULE_SECURITY_PROVIDER_ENABLE_HYBRID_DRBG = "mule.security.provider.enableHybridDrbg";
    private static final String FIPS_KEY = "fips";
    public static final String FIPS_VALUE_DEFAULT = "BCFIPS";
    public static final String FIPS_PROVIDER_KEY = "mule.fips.provider";
    public static final String JSSE_PROVIDER_KEY = "mule.jsse.provider";
    public static final String MULE_SSL_KEY_MANAGER_FACTORY_ALGORITHM_KEY = "mule.ssl.KeyManagerFactory.algorithm";
    public static final String MULE_SSL_TRUST_MANAGER_FACTORY_ALGORITHM_KEY = "mule.ssl.TrustManagerFactory.algorithm";
    public static final String MULE_KEYSTORE_TYPE_KEY = "mule.keystore.type";
    public static final String MULE_FIPS_VALUE_KEY = "mule.fips.value";
    public static final String DEFAULT_FIPS_PROVIDER = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    private static final String FIPS_CONFIG_HYBRID_ENTROPY_POOL = "C:HYBRID;ENABLE{ALL};";
    public static final String DEFAULT_JSSE_PROVIDER = "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider";
    public static final String KEY_MANAGER_FACTORY_ALGORITHM_KEY = "ssl.KeyManagerFactory.algorithm";
    public static final String DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM_VALUE = "PKIX";
    public static final String KEYSTORE_TYPE_KEY = "keystore.type";
    public static final String DEFAULT_KEYSTORE_TYPE_VALUE = "BCFKS";
    private static final String LEGACY_SUN_JSSE_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    public static final String TRUST_MANAGER_FACTORY_ALGORITHM_KEY = "ssl.KeyManagerFactory.algorithm";
    private static final String SUN_JSSE_PROVIDER = "SunJSSE";

    @Override
    public void configureFips() throws FipsSecurityConfigurationException {
        try {
            this.configureSecurityManager();
        }
        catch (ReflectiveOperationException e) {
            throw new FipsSecurityConfigurationException(e);
        }
        this.setSecurityAlgorithm();
    }

    private void configureSecurityManager() throws ReflectiveOperationException {
        Provider fipsProvider = DefaultFipsSecurityManager.createFipsProvider();
        Security.insertProviderAt(fipsProvider, 1);
        Provider jsseProvider = DefaultFipsSecurityManager.createJsseProvider();
        Security.insertProviderAt(jsseProvider, 2);
        Provider sunJsseProvider = Security.getProvider(SUN_JSSE_PROVIDER);
        Provider sunJsseProviderLegacy = Security.getProvider(LEGACY_SUN_JSSE_PROVIDER);
        if (sunJsseProvider != null) {
            Security.removeProvider(SUN_JSSE_PROVIDER);
        }
        if (sunJsseProviderLegacy != null) {
            sunJsseProviderLegacy.setProperty(FIPS_VALUE_DEFAULT, "");
        }
    }

    public static Provider createJsseProvider() throws ReflectiveOperationException {
        Class<?> classDef = Class.forName(System.getProperty(JSSE_PROVIDER_KEY, DEFAULT_JSSE_PROVIDER));
        Constructor<?> constructor = classDef.getConstructor(new Class[0]);
        Provider jsseProvider = (Provider)constructor.newInstance(new Object[0]);
        jsseProvider.setProperty(FIPS_KEY, System.getProperty(MULE_FIPS_VALUE_KEY, FIPS_VALUE_DEFAULT));
        return jsseProvider;
    }

    public static Provider createFipsProvider() throws ReflectiveOperationException {
        Class<?> classDef = Class.forName(System.getProperty(FIPS_PROVIDER_KEY, DEFAULT_FIPS_PROVIDER));
        String muleSecurityProviderEnableHybridDrbg = System.getProperty(MULE_SECURITY_PROVIDER_ENABLE_HYBRID_DRBG, "true");
        if (!Boolean.valueOf(muleSecurityProviderEnableHybridDrbg).booleanValue()) {
            return (Provider)classDef.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return (Provider)classDef.getConstructor(String.class).newInstance(FIPS_CONFIG_HYBRID_ENTROPY_POOL);
    }

    private void setSecurityAlgorithm() {
        Security.setProperty("ssl.KeyManagerFactory.algorithm", System.getProperty(MULE_SSL_KEY_MANAGER_FACTORY_ALGORITHM_KEY, DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM_VALUE));
        Security.setProperty("ssl.KeyManagerFactory.algorithm", System.getProperty(MULE_SSL_TRUST_MANAGER_FACTORY_ALGORITHM_KEY, DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM_VALUE));
        Security.setProperty(KEYSTORE_TYPE_KEY, System.getProperty(MULE_KEYSTORE_TYPE_KEY, DEFAULT_KEYSTORE_TYPE_VALUE));
    }
}

