/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.util;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.framework.internal.InternalMuleFramework;

public final class CloseChecker {
    private volatile boolean closing = false;
    private volatile boolean closed = false;
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    private final String objectName;
    private final InternalMuleFramework muleFramework;

    public CloseChecker(String objectName, InternalMuleFramework muleFramework) {
        this.objectName = objectName;
        this.muleFramework = muleFramework;
    }

    public <T> T withLifecycleCheck(Supplier<T> closure) {
        this.closeLock.readLock().lock();
        try {
            this.muleFramework.assertStarted();
            if (this.closing) {
                throw new IllegalStateException(this.objectName + " is being closed");
            }
            if (this.closed) {
                throw new IllegalStateException(this.objectName + " is closed");
            }
            T t = closure.get();
            return t;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    public <T> void withLifecycleCheck(Consumer<T> closure, T t) {
        this.withLifecycleCheck(() -> {
            closure.accept(t);
            return t;
        });
    }

    public void close(Runnable closeAction) {
        this.closeLock.writeLock().lock();
        try {
            this.closing = true;
            closeAction.run();
            this.closed = true;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
    }

    public void close() {
        this.close(() -> {});
    }
}

