/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.UnionType;
import org.mule.runtime.api.meta.model.nested.ChainExecutionOccurrence;
import org.mule.runtime.api.util.Pair;

public class VariablesTracker {
    private static final MetadataType NULL_TYPE = new BaseTypeBuilder(MetadataFormat.JAVA).nullType().build();
    private final Deque<Map<String, MetadataType>> lastVariables = new ArrayDeque<Map<String, MetadataType>>();

    public VariablesTracker() {
        this.lastVariables.push(new HashMap());
    }

    public void addVariablesPreComposable(Map<String, MetadataType> addedVars) {
        HashMap<String, MetadataType> vars = new HashMap<String, MetadataType>(this.lastVariables.pop());
        vars.putAll(addedVars);
        this.lastVariables.push(vars);
    }

    public void combineVariables(List<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>> chainsVariables) {
        this.combineVariables(chainsVariables, VariablesTracker::unionOf);
    }

    public void combineVariables(List<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>> chainsVariables, BiFunction<MetadataType, MetadataType, MetadataType> combinationFunction) {
        Map preChainsVariables = Optional.ofNullable(this.lastVariables.peek()).orElse(Collections.emptyMap());
        HashMap<String, MetadataType> addedVars = new HashMap<String, MetadataType>();
        HashSet alwaysHaveValueSet = new HashSet();
        HashMap presencePotentiallyExecuted = new HashMap();
        chainsVariables.forEach(chainVars -> ((Map)chainVars.getFirst()).forEach((name, type) -> {
            if (this.chainMayNotBeExecuted((ChainExecutionOccurrence)chainVars.getSecond())) {
                presencePotentiallyExecuted.put(name, presencePotentiallyExecuted.getOrDefault(name, 0) + 1);
            } else {
                alwaysHaveValueSet.add(name);
            }
            if (preChainsVariables.containsKey(name) && ((MetadataType)preChainsVariables.get(name)).equals(type)) {
                return;
            }
            if (!addedVars.containsKey(name)) {
                addedVars.put((String)name, (MetadataType)type);
                return;
            }
            MetadataType combinedType = (MetadataType)combinationFunction.apply((MetadataType)addedVars.get(name), (MetadataType)type);
            if (combinedType != null) {
                addedVars.put((String)name, combinedType);
            }
        }));
        for (String name : addedVars.keySet()) {
            if (alwaysHaveValueSet.contains(name)) continue;
            MetadataType preChainType = (MetadataType)preChainsVariables.get(name);
            if (preChainType != null) {
                addedVars.put(name, VariablesTracker.unionOf((MetadataType)addedVars.get(name), preChainType));
            }
            if (((Integer)presencePotentiallyExecuted.get(name)).intValue() == chainsVariables.size()) continue;
            addedVars.put(name, VariablesTracker.unionOf((MetadataType)addedVars.get(name), NULL_TYPE));
        }
        HashMap<String, MetadataType> vars = new HashMap<String, MetadataType>(preChainsVariables);
        vars.putAll(addedVars);
        this.lastVariables.push(vars);
    }

    private boolean chainMayNotBeExecuted(ChainExecutionOccurrence occurrence) {
        return occurrence.equals((Object)ChainExecutionOccurrence.ONCE_OR_NONE) || occurrence.equals((Object)ChainExecutionOccurrence.MULTIPLE_OR_NONE) || occurrence.equals((Object)ChainExecutionOccurrence.UNKNOWN);
    }

    public void saveCurrentVariables() {
        this.lastVariables.push(this.lastVariables.peek());
    }

    public void enterChain() {
        this.saveCurrentVariables();
    }

    public void exitChain() {
        this.goBackToPreviousVariables();
    }

    public Map<String, MetadataType> getCurrentVariables() {
        return this.lastVariables.peek();
    }

    public void setCurrentVariables(Map<String, MetadataType> newVars) {
        this.lastVariables.pop();
        this.lastVariables.push(newVars);
    }

    public void addVariable(String name, MetadataType type) {
        HashMap<String, MetadataType> newVars = new HashMap<String, MetadataType>(this.getCurrentVariables());
        newVars.put(name, type);
        this.setCurrentVariables(newVars);
    }

    public void goBackToPreviousVariables() {
        this.lastVariables.pop();
    }

    public void removeVariable(String name) {
        HashMap<String, MetadataType> vars = new HashMap<String, MetadataType>(this.getCurrentVariables());
        vars.remove(name);
        this.setCurrentVariables(vars);
    }

    private static MetadataType unionOf(MetadataType a, MetadataType b) {
        return VariablesTracker.unionOf(Arrays.asList(a, b));
    }

    private static MetadataType unionOf(Iterable<MetadataType> types) {
        UnionTypeBuilder builder = new BaseTypeBuilder(MetadataFormat.JAVA).unionType().flattens().removesRepetitions();
        for (MetadataType type : types) {
            builder.of(type);
        }
        UnionType result = builder.build();
        if (result.getTypes().size() > 1) {
            return result;
        }
        return (MetadataType)result.getTypes().get(0);
    }
}

