/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.mule.framework.internal.tooling.type.catalog.model.MetadataFormats;
import org.mule.framework.internal.tooling.type.propagation.utils.CoreUtils;
import org.mule.framework.internal.tooling.type.propagation.utils.ExpressionsTypeResolver;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class CoreTransformersHandler {
    private static final String MESSAGE_GROUP_NAME = "Message";
    private static final String SET_VARIABLES_GROUP_NAME = "Set Variables";
    private static final String SET_VARIABLE_OBJECT_GROUP_NAME = "SetVariable";
    private static final MetadataType STRING_TYPE = new BaseTypeBuilder(MetadataFormats.JAVA).stringType().build();
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

    public CoreTransformersHandler(ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    }

    public void handle(ComponentAst componentAst, TypeBindings bindings, Consumer<MetadataType> onPayloadTypeSet, Consumer<MetadataType> onAttributesTypeSet, BiConsumer<String, MetadataType> onVariableTypeSet, Consumer<String> onVariableRemoved, Runnable onSuccess, Consumer<MetadataFailure> onFailure) {
        ComponentIdentifier identifier = componentAst.getIdentifier();
        ExpressionsTypeResolver expressionsOutputTypeResolver = new ExpressionsTypeResolver(this.expressionLanguageMetadataService, bindings);
        if (identifier.equals(CoreUtils.SET_PAYLOAD_IDENTIFIER)) {
            this.getValueParameterPropagatedType(componentAst, "General", expressionsOutputTypeResolver, Optional.empty(), onPayloadTypeSet.andThen(t -> onSuccess.run()), onFailure);
        } else if (identifier.equals(CoreUtils.SET_VARIABLE_IDENTIFIER)) {
            this.getValueParameterPropagatedType(componentAst, "General", expressionsOutputTypeResolver, Optional.empty(), type -> {
                String name = this.getVariableName(componentAst, "General");
                onVariableTypeSet.accept(name, (MetadataType)type);
                onSuccess.run();
            }, onFailure);
        } else if (identifier.equals(CoreUtils.REMOVE_VARIABLE_IDENTIFIER)) {
            onVariableRemoved.accept(this.getVariableName(componentAst, "General"));
            onSuccess.run();
        } else if (identifier.equals(CoreUtils.EE_TRANSFORM_IDENTIFIER)) {
            this.handleTransform(componentAst, expressionsOutputTypeResolver, onPayloadTypeSet, onAttributesTypeSet, onVariableTypeSet, onSuccess, onFailure);
        } else if (identifier.equals(CoreUtils.MUNIT_SET_EVENT_IDENTIFIER)) {
            this.handleMunitSetEvent(componentAst, expressionsOutputTypeResolver, onPayloadTypeSet, onAttributesTypeSet, onVariableTypeSet, onSuccess, onFailure);
        }
    }

    private void handleTransform(ComponentAst component, ExpressionsTypeResolver expressionsTypeResolver, Consumer<MetadataType> onPayload, Consumer<MetadataType> onAttributes, BiConsumer<String, MetadataType> onVariable, Runnable onSuccess, Consumer<MetadataFailure> onFailure) {
        this.getParameterValue(component, MESSAGE_GROUP_NAME, "setPayload").flatMap(c -> this.getScript((ComponentAst)c, "SetPayload")).map(expressionsTypeResolver::getOutputType).ifPresent(onPayload);
        this.getParameterValue(component, MESSAGE_GROUP_NAME, "setAttributes").flatMap(c -> this.getScript((ComponentAst)c, "SetAttributes")).map(expressionsTypeResolver::getOutputType).ifPresent(onAttributes);
        this.getParameterValue(component, SET_VARIABLES_GROUP_NAME, "variables").orElseGet(Collections::emptyList).forEach(varAst -> this.getScript((ComponentAst)varAst, SET_VARIABLE_OBJECT_GROUP_NAME).ifPresent(expression -> {
            String name = this.getVariableName((ComponentAst)varAst, SET_VARIABLE_OBJECT_GROUP_NAME);
            onVariable.accept(name, expressionsTypeResolver.getOutputType((String)expression));
        }));
        Optional<MetadataFailure> failure = expressionsTypeResolver.getFailure();
        if (failure.isPresent()) {
            onFailure.accept(failure.get());
        } else {
            onSuccess.run();
        }
    }

    private void handleMunitSetEvent(ComponentAst component, ExpressionsTypeResolver expressionsTypeResolver, Consumer<MetadataType> onPayload, Consumer<MetadataType> onAttributes, BiConsumer<String, MetadataType> onVariable, Runnable onSuccess, Consumer<MetadataFailure> onFailure) {
        Optional<MetadataFailure> failure;
        List variables;
        ComponentAst attributesAst;
        ComponentAst payloadAst = (ComponentAst)component.getParameter("General", "payload").getValue().getRight();
        if (payloadAst != null) {
            this.getValueParameterPropagatedType(payloadAst, "Payload", expressionsTypeResolver, Optional.of(STRING_TYPE), onPayload, onFailure);
        }
        if ((attributesAst = (ComponentAst)component.getParameter("General", "attributes").getValue().getRight()) != null) {
            this.getValueParameterPropagatedType(attributesAst, "EventAttributes", expressionsTypeResolver, Optional.of(STRING_TYPE), onAttributes, onFailure);
        }
        if ((variables = (List)component.getParameter("General", "variables").getValue().getRight()) != null) {
            variables.forEach(var -> {
                String varName = (String)var.getParameter("Variable", "key").getValue().getRight();
                this.getValueParameterPropagatedType((ComponentAst)var, "Variable", expressionsTypeResolver, Optional.of(STRING_TYPE), type -> onVariable.accept(varName, (MetadataType)type), onFailure);
            });
        }
        if ((failure = expressionsTypeResolver.getFailure()).isPresent()) {
            onFailure.accept(failure.get());
        } else {
            onSuccess.run();
        }
    }

    private void getValueParameterPropagatedType(ComponentAst componentAst, String paramGroup, ExpressionsTypeResolver expressionsTypeResolver, Optional<MetadataType> fallback, Consumer<MetadataType> onSuccess, Consumer<MetadataFailure> onFailure) {
        ComponentParameterAst parameterAst = componentAst.getParameter(paramGroup, "value");
        Either valueParam = parameterAst.getValue();
        MetadataType type = valueParam.isLeft() ? expressionsTypeResolver.getOutputType((String)valueParam.getLeft()) : fallback.orElse(parameterAst.getModel().getType());
        Optional<MetadataFailure> failure = expressionsTypeResolver.getFailure();
        if (failure.isPresent()) {
            onFailure.accept(failure.get());
        } else {
            onSuccess.accept(type);
        }
    }

    private Optional<String> getScript(ComponentAst componentAst, String groupName) {
        return Optional.ofNullable(componentAst.getParameter(groupName, "script")).flatMap(param -> Optional.ofNullable((String)param.getValue().getLeft()));
    }

    private String getVariableName(ComponentAst componentAst, String groupName) {
        return (String)this.getParameterValue(componentAst, groupName, "variableName").orElseThrow(() -> new IllegalArgumentException(String.format("Missing required parameter `variableName` on component `%s @ %s`", componentAst.getIdentifier(), componentAst.getLocation())));
    }

    private <T> Optional<T> getParameterValue(ComponentAst componentAst, String groupName, String parameterName) {
        return Optional.ofNullable(componentAst.getParameter(groupName, parameterName)).flatMap(param -> Optional.ofNullable(param.getValue().getRight()));
    }
}

