/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import java.util.Optional;
import java.util.stream.Stream;
import org.mule.framework.internal.tooling.type.propagation.utils.ExpressionsTypeResolver;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.module.extension.api.metadata.PropagatedParameterTypeResolver;

public class CFGPropagatedParameterTypeResolver
implements PropagatedParameterTypeResolver {
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final TypeBindings typeBindings;
    private final ComponentAst componentAst;

    public CFGPropagatedParameterTypeResolver(ExpressionLanguageMetadataService expressionLanguageMetadataService, TypeBindings typeBindings, ComponentAst componentAst) {
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.typeBindings = typeBindings;
        this.componentAst = componentAst;
    }

    public Optional<MetadataType> getResolvedType(String parameterName) throws MetadataResolvingException {
        Optional expression = this.componentAst.getParameters().stream().filter(parameterAst -> parameterAst.getModel().getName().equals(parameterName)).flatMap(this::getExpression).findFirst();
        ExpressionsTypeResolver expressionsTypeResolver = new ExpressionsTypeResolver(this.expressionLanguageMetadataService, this.typeBindings);
        Optional<MetadataType> resolvedType = expression.map(expressionsTypeResolver::getOutputType);
        Optional<MetadataFailure> failure = expressionsTypeResolver.getFailure();
        if (failure.isPresent()) {
            throw new MetadataResolvingException(String.format("Error resolving metadata from expression %s: %s", expression, failure.get()), failure.get().getFailureCode());
        }
        return resolvedType;
    }

    private Stream<String> getExpression(ComponentParameterAst parameterAst) {
        return this.streamOfNullable((String)parameterAst.getValue().getLeft());
    }

    private <T> Stream<T> streamOfNullable(T value) {
        return value == null ? Stream.empty() : Stream.of(value);
    }
}

