/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.override.enrichment.model;

import com.mulesoft.mule.framework.api.tooling.type.override.TypeOverrideKey;
import org.mule.runtime.ast.api.ComponentAst;

public class DefaultTypeOverrideKey
implements TypeOverrideKey {
    private static final String BY_DOC_ID_PREFIX = "#";
    private static final String BY_LOCATION_PREFIX = "@";
    private final String docId;
    private final String componentLocation;

    public DefaultTypeOverrideKey(ComponentAst componentAst) {
        this.docId = (String)componentAst.getMetadata().getDocAttributes().get("id");
        this.componentLocation = componentAst.getLocation().getLocation();
    }

    public DefaultTypeOverrideKey(String docId, String componentLocation) {
        this.docId = docId;
        this.componentLocation = componentLocation;
    }

    public boolean matches(String selectorString) {
        if (selectorString.startsWith(BY_DOC_ID_PREFIX)) {
            return this.matchesDocId(selectorString.substring(1));
        }
        if (selectorString.startsWith(BY_LOCATION_PREFIX)) {
            return this.matchesLocation(selectorString.substring(1));
        }
        return false;
    }

    private boolean matchesDocId(String selectorString) {
        return this.docId != null && this.docId.equals(selectorString);
    }

    private boolean matchesLocation(String selectorString) {
        return this.componentLocation != null && this.componentLocation.equals(selectorString);
    }
}

