/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.override.declarations.loader.xml;

import java.util.Optional;
import java.util.function.BiConsumer;
import javax.xml.namespace.QName;
import org.mule.framework.internal.tooling.type.catalog.model.TypesCatalog;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.TypeResolverException;
import org.mule.framework.internal.tooling.type.catalog.util.xml.XmlMatcher;
import org.mule.framework.internal.tooling.type.override.declarations.loader.TypeOverrideDeclarationLoaderContext;
import org.mule.framework.internal.tooling.type.override.declarations.loader.xml.AbstractTypeOverrideDeclarationXmlLoader;
import org.mule.framework.internal.tooling.type.override.declarations.model.TypeOverrideDeclaration;
import org.mule.framework.internal.tooling.type.override.declarations.model.TypeOverrideDeclarationBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.w3c.dom.Element;

public class ExtensionOperationTypeOverrideDeclarationXmlLoader
extends AbstractTypeOverrideDeclarationXmlLoader {
    private static final String NS_TYPES = "http://www.mulesoft.org/schema/mule/types";
    private static final QName ELEM_OP_DECLARATION = new QName("http://www.mulesoft.org/schema/mule/types", "operation-declaration");
    private static final QName ELEM_INPUTS = new QName("http://www.mulesoft.org/schema/mule/types", "inputs");
    private static final QName ELEM_OUTPUTS = new QName("http://www.mulesoft.org/schema/mule/types", "outputs");
    private static final QName ELEM_PAYLOAD = new QName("http://www.mulesoft.org/schema/mule/types", "payload");
    private static final QName ELEM_ATTRIBUTES = new QName("http://www.mulesoft.org/schema/mule/types", "attributes");
    private static final QName ELEM_PARAMETER = new QName("http://www.mulesoft.org/schema/mule/types", "parameter");
    private static final String ATTR_TYPE = "type";

    @Override
    public Optional<TypeOverrideDeclaration> load(Element element, TypeOverrideDeclarationLoaderContext context) {
        return XmlMatcher.match(element, ELEM_OP_DECLARATION).map(opDeclaration -> {
            TypeOverrideDeclarationBuilder declarationBuilder = TypeOverrideDeclaration.builder();
            this.foreachParameterType((XmlMatcher)opDeclaration, context.getTypesCatalog(), declarationBuilder::withParameterType);
            this.loadPayloadType((XmlMatcher)opDeclaration, context.getTypesCatalog()).ifPresent(declarationBuilder::withReturnPayloadType);
            this.loadAttributesType((XmlMatcher)opDeclaration, context.getTypesCatalog()).ifPresent(declarationBuilder::withReturnAttributesType);
            return declarationBuilder.build();
        });
    }

    private Optional<MetadataType> loadPayloadType(XmlMatcher opDeclaration, TypesCatalog typesCatalog) {
        return this.loadOutputElementType(opDeclaration, typesCatalog, ELEM_PAYLOAD);
    }

    private Optional<MetadataType> loadAttributesType(XmlMatcher opDeclaration, TypesCatalog typesCatalog) {
        return this.loadOutputElementType(opDeclaration, typesCatalog, ELEM_ATTRIBUTES);
    }

    private Optional<MetadataType> loadOutputElementType(XmlMatcher opDeclaration, TypesCatalog typesCatalog, QName elementQName) {
        return opDeclaration.match(ELEM_OUTPUTS).flatMap(outputsMatcher -> outputsMatcher.match(elementQName)).flatMap(payloadMatcher -> {
            String typeExpression = payloadMatcher.requireAttribute(ATTR_TYPE);
            try {
                return Optional.ofNullable(this.resolveType(typeExpression, typesCatalog));
            }
            catch (TypeResolverException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void foreachParameterType(XmlMatcher opDeclaration, TypesCatalog typesCatalog, BiConsumer<String, MetadataType> callback) {
        this.iterateDictionaryOfTypes(opDeclaration, ELEM_INPUTS, ELEM_PARAMETER, typesCatalog, callback);
    }
}

