/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.dw;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public abstract class AbstractDwTypeLoader
implements TypeLoader {
    private final File file;
    private final MetadataFormat metadataFormat;
    private final String content;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

    protected AbstractDwTypeLoader(File file, MetadataFormat metadataFormat, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(metadataFormat, "metadataFormat");
        Objects.requireNonNull(expressionLanguageMetadataService, "expressionLanguageMetadataService");
        this.file = file;
        this.metadataFormat = metadataFormat;
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.content = null;
    }

    protected AbstractDwTypeLoader(String content, MetadataFormat metadataFormat, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(metadataFormat, "metadataFormat");
        Objects.requireNonNull(expressionLanguageMetadataService, "expressionLanguageMetadataService");
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.file = null;
        this.content = content;
        this.metadataFormat = metadataFormat;
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        Optional<MetadataType> optional;
        block8: {
            InputStream inputStream = this.loadInputStream();
            try {
                optional = this.doLoad(typeIdentifier, null, this.expressionLanguageMetadataService, this.metadataFormat, inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return optional;
    }

    protected abstract Optional<MetadataType> doLoad(String var1, String var2, ExpressionLanguageMetadataService var3, MetadataFormat var4, InputStream var5) throws IOException;

    protected InputStream loadInputStream() throws FileNotFoundException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content.getBytes());
        }
        throw new RuntimeException("Invalid file content specified.");
    }
}

