/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.catalog.loader.xml;

import java.io.InputStream;
import javax.xml.namespace.QName;
import org.mule.framework.internal.tooling.type.catalog.builder.TypesCatalogBuilder;
import org.mule.framework.internal.tooling.type.catalog.builder.TypesResolverBuilder;
import org.mule.framework.internal.tooling.type.catalog.loader.BaseTypesCatalogLoader;
import org.mule.framework.internal.tooling.type.catalog.loader.TypesCatalogLoadingException;
import org.mule.framework.internal.tooling.type.catalog.util.xml.XmlMatcher;
import org.mule.framework.internal.tooling.type.catalog.util.xml.XmlUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class TypesCatalogXmlLoader
extends BaseTypesCatalogLoader {
    private static final String NS_TYPES = "http://www.mulesoft.org/schema/mule/types";
    private static final QName ELEM_MULE = new QName("http://www.mulesoft.org/schema/mule/types", "mule");
    private static final QName ELEM_CATALOG = new QName("http://www.mulesoft.org/schema/mule/types", "catalog");
    private static final QName ELEM_TYPE = new QName("http://www.mulesoft.org/schema/mule/types", "type");
    private static final String ELEM_TYPE_ATTR_NAME = "name";
    private static final String ELEM_TYPE_ATTR_FORMAT = "format";
    private static final QName ELEM_SHAPE = new QName("http://www.mulesoft.org/schema/mule/types", "shape");
    private static final String ELEM_SHAPE_ATTR_FORMAT = "format";
    private static final String ELEM_SHAPE_ATTR_LOCATION = "location";
    private static final String ELEM_SHAPE_ATTR_ELEMENT = "element";
    private static final QName ELEM_EXAMPLE = new QName("http://www.mulesoft.org/schema/mule/types", "example");
    private static final String ELEM_EXAMPLE_ATTR_FORMAT = "format";
    private static final String ELEM_EXAMPLE_ATTR_LOCATION = "location";
    private static final String ELEM_EXAMPLE_ATTR_ELEMENT = "element";

    @Override
    protected void loadFiles(Iterable<InputStream> files, TypesCatalogBuilder typesCatalogBuilder) throws TypesCatalogLoadingException {
        for (InputStream file : files) {
            this.loadStream(file, typesCatalogBuilder);
        }
    }

    protected void loadStream(InputStream stream, TypesCatalogBuilder typesCatalogBuilder) throws TypesCatalogLoadingException {
        try {
            this.load(XmlUtils.parseRootElement(new InputSource(stream)), typesCatalogBuilder);
        }
        catch (Exception e) {
            throw new TypesCatalogLoadingException(e);
        }
    }

    private void load(Element documentElement, TypesCatalogBuilder typesCatalogBuilder) {
        XmlMatcher.match(documentElement, ELEM_MULE).ifPresent(xmlMatcher -> TypesCatalogXmlLoader.loadElemMule(xmlMatcher, typesCatalogBuilder));
    }

    private static void loadElemMule(XmlMatcher muleElem, TypesCatalogBuilder typesCatalogBuilder) {
        muleElem.matchMany(ELEM_CATALOG).forEach(catalog -> TypesCatalogXmlLoader.loadElemCatalog(catalog, typesCatalogBuilder));
    }

    private static void loadElemCatalog(XmlMatcher catalogElem, TypesCatalogBuilder typesCatalogBuilder) {
        catalogElem.matchMany(ELEM_TYPE).forEach(type -> TypesCatalogXmlLoader.loadTypeElem(type, typesCatalogBuilder));
    }

    private static void loadTypeElem(XmlMatcher typeElem, TypesCatalogBuilder typesCatalogBuilder) {
        typesCatalogBuilder.addTypesResolver(typesResolverBuilder -> TypesCatalogXmlLoader.typePartsToBuilder(typeElem, typesResolverBuilder));
    }

    private static void typePartsToBuilder(XmlMatcher typeElem, TypesResolverBuilder typesResolverBuilder) {
        typeElem.matchAttribute(ELEM_TYPE_ATTR_NAME).ifPresent(typesResolverBuilder::name);
        typeElem.matchAttribute("format").ifPresent(typesResolverBuilder::format);
        typeElem.match(ELEM_SHAPE).ifPresent(shape -> TypesCatalogXmlLoader.handleShapeElement(shape, typesResolverBuilder));
        typeElem.match(ELEM_EXAMPLE).ifPresent(example -> TypesCatalogXmlLoader.handleExampleElement(typesResolverBuilder, example));
    }

    private static void handleExampleElement(TypesResolverBuilder typesResolverBuilder, XmlMatcher example) {
        example.matchAttribute("location").ifPresent(typesResolverBuilder::exampleLocation);
        example.matchAttribute("format").ifPresent(typesResolverBuilder::exampleFormat);
        example.matchAttributeNode("element").ifPresent(elementAttr -> {
            QName elementQName = XmlMatcher.resolveQName(elementAttr).orElse(QName.valueOf(elementAttr.getTextContent()));
            typesResolverBuilder.exampleElement(elementQName.toString());
        });
        String content = example.value();
        if (!content.isEmpty()) {
            typesResolverBuilder.exampleContent(content);
        }
    }

    private static void handleShapeElement(XmlMatcher shape, TypesResolverBuilder typesResolverBuilder) {
        shape.matchAttribute("location").ifPresent(typesResolverBuilder::shapeLocation);
        shape.matchAttribute("format").ifPresent(typesResolverBuilder::shapeFormat);
        shape.matchAttributeNode("element").ifPresent(elementAttr -> {
            QName elementQName = XmlMatcher.resolveQName(elementAttr).orElse(QName.valueOf(elementAttr.getTextContent()));
            typesResolverBuilder.shapeElement(elementQName.toString());
        });
        String content = shape.value();
        if (!content.isEmpty()) {
            typesResolverBuilder.shapeContent(content);
        }
    }
}

