/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.catalog;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.tooling.type.catalog.builder.TypesCatalogBuilderContext;
import org.mule.framework.internal.tooling.type.catalog.loader.xml.TypesCatalogXmlLoader;
import org.mule.framework.internal.tooling.type.catalog.model.TypesCatalog;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypesCatalogHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypesCatalogHelper.class);

    private TypesCatalogHelper() {
    }

    public static TypesCatalog loadTypesCatalog(String fileName, InternalMuleFramework internalMuleFramework) {
        try {
            return TypesCatalogHelper.loadTypesCatalog(fileName, internalMuleFramework.getExecutionClassLoader(), internalMuleFramework.getExpressionLanguageMetadataService());
        }
        catch (Exception e) {
            LOGGER.error("Error while loading the types catalog", (Throwable)e);
            return new TypesCatalog(Collections.emptyList());
        }
    }

    public static TypesCatalog loadTypesCatalog(String fileName, ClassLoader classLoader, ExpressionLanguageMetadataService expressionLanguageMetadataService) throws Exception {
        if (classLoader == null) {
            LOGGER.warn("Execution classloader is null while trying to load the types catalog");
            return new TypesCatalog(Collections.emptyList());
        }
        URL appTypesUrl = classLoader.getResource(fileName);
        if (appTypesUrl == null) {
            return new TypesCatalog(Collections.emptyList());
        }
        try (InputStream appTypesStream = appTypesUrl.openStream();){
            URI baseUri = Paths.get(appTypesUrl.toURI()).getParent().toUri();
            TypesCatalogBuilderContext typesCatalogBuilderContext = new TypesCatalogBuilderContext(expressionLanguageMetadataService);
            TypesCatalog typesCatalog = new TypesCatalogXmlLoader().loadFiles(Collections.singletonList(appTypesStream), typesCatalogBuilderContext, baseUri);
            return typesCatalog;
        }
    }
}

