/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.connectivity;

import java.util.stream.Collectors;
import org.mule.framework.internal.tooling.connectivity.AbstractWithConnectionProviderCommand;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;

public class ConnectivityTestCommand
extends AbstractWithConnectionProviderCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConnectionValidationResult execute(ExtensionModel extensionModel, ComponentParameterization<ConnectionProviderModel> connectionProviderParameterization, MuleContext muleContext, ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory) {
        ConnectionValidationResult connectionValidationResult;
        ConnectionProvider<Object> connectionProvider = null;
        Object connection = null;
        try {
            connectionProvider = this.createConnectionProvider((ConnectionProviderModel)connectionProviderParameterization.getModel(), connectionProviderParameterization.getParameters().entrySet().stream().collect(Collectors.toMap(e -> ((ParameterModel)((Pair)e.getKey()).getSecond()).getName(), e -> e.getValue())), extensionModel, muleContext, extensionDesignTimeResolversFactory);
            connection = connectionProvider.connect();
            this.initialiseConnection(connection, muleContext.getInjector());
            connectionValidationResult = connectionProvider.validate(connection);
            if (connectionProvider == null) return connectionValidationResult;
        }
        catch (Exception e2) {
            ConnectionValidationResult connectionValidationResult2 = ConnectionValidationResult.failure((String)"Failed to perform connectivity test", (Exception)e2);
            return connectionValidationResult2;
        }
        try {
            if (connection == null) return connectionValidationResult;
            connectionProvider.disconnect(connection);
            return connectionValidationResult;
        }
        finally {
            if (connectionProvider != null) {
                try {
                    if (connection != null) {
                        connectionProvider.disconnect(connection);
                    }
                }
                finally {
                    MuleFrameworkUtils.stopAndDispose(connectionProvider);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionValidationResult execute(ConnectionProvider<Object> connectionProvider, Injector injector) {
        Object connection = null;
        try {
            connection = connectionProvider.connect();
            this.initialiseConnection(connection, injector);
            ConnectionValidationResult connectionValidationResult = connectionProvider.validate(connection);
            return connectionValidationResult;
        }
        catch (Exception e) {
            ConnectionValidationResult connectionValidationResult = ConnectionValidationResult.failure((String)"Failed to perform connectivity test", (Exception)e);
            return connectionValidationResult;
        }
        finally {
            if (connectionProvider != null && connection != null) {
                connectionProvider.disconnect(connection);
            }
        }
    }

    private void initialiseConnection(Object connection, Injector injector) throws MuleException {
        injector.inject(connection);
    }
}

