/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.extension.source;

import com.mulesoft.mule.framework.api.extension.source.SourceHandler;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceHandlerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceHandlerRegistry.class);
    private final Set<SourceHandler> sourceHandlers = Collections.newSetFromMap(new ConcurrentHashMap());

    public synchronized void registerSourceHandler(SourceHandler sourceHandler) {
        if (this.sourceHandlers.contains(sourceHandler)) {
            throw new IllegalStateException("SourceHandler '" + sourceHandler.toString() + "' already exists");
        }
        this.sourceHandlers.add(sourceHandler);
    }

    public synchronized void disposeAllSourceHandlers() {
        this.sourceHandlers.forEach(source -> {
            try {
                source.stop();
            }
            catch (Exception e) {
                LOGGER.error(String.format("Could not stop source %s during framework shutdown: %s", source, e.getMessage()), (Throwable)e);
            }
            try {
                source.dispose();
            }
            catch (Exception e) {
                LOGGER.error(String.format("Could not dsipose source %s during framework shutdown: %s", source, e.getMessage()), (Throwable)e);
            }
        });
    }
}

