/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.extension;

import com.mulesoft.mule.framework.api.execution.MuleExecutionFramework;
import com.mulesoft.mule.framework.api.extension.operation.fluent.OperationCommand;
import com.mulesoft.mule.framework.api.extension.source.SourceHandler;
import com.mulesoft.mule.framework.api.extension.source.SourceResultHandler;
import com.mulesoft.mule.framework.api.extension.source.fluent.SourceCreationCommand;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.extension.operation.fluent.DietOperationCommand;
import org.mule.framework.internal.extension.source.DietSourceHandlerAdapter;
import org.mule.framework.internal.extension.source.DietSourceResultHandlerAdapter;
import org.mule.framework.internal.extension.source.SourceHandlerRegistry;
import org.mule.framework.internal.extension.source.fluent.DietSourceCreationCommand;
import org.mule.framework.internal.util.CloseChecker;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class DietMuleExecutionFramework
implements MuleExecutionFramework {
    private final CloseChecker closer;
    private final InternalMuleFramework muleFramework;
    private final ExtensionsClient extensionsClient;
    private final SourceHandlerRegistry sourceHandlerRegistry;

    public DietMuleExecutionFramework(InternalMuleFramework muleFramework) {
        this.muleFramework = muleFramework;
        this.extensionsClient = muleFramework.getExtensionsClient();
        this.sourceHandlerRegistry = new SourceHandlerRegistry();
        this.closer = new CloseChecker("DietMuleExecutionFramework", muleFramework);
    }

    public <T, A> CompletableFuture<Result<T, A>> executeOperation(String extensionName, Consumer<OperationCommand> command) {
        return this.closer.withLifecycleCheck(() -> {
            MuleFrameworkUtils.assertExtensionModelLoader(this.muleFramework, extensionName);
            Thread currentThread = Thread.currentThread();
            ClassLoader originalClassLoader = currentThread.getContextClassLoader();
            DietOperationCommand request = new DietOperationCommand(this.muleFramework);
            command.accept(request);
            currentThread.setContextClassLoader(this.muleFramework.getExecutionClassLoader());
            try {
                CompletableFuture completableFuture = this.extensionsClient.execute(extensionName, request.getOperationName(), request::parameterize);
                return completableFuture;
            }
            finally {
                currentThread.setContextClassLoader(originalClassLoader);
            }
        });
    }

    public <T, A> SourceHandler createSource(String extensionName, Consumer<SourceCreationCommand> command, Consumer<SourceResultHandler<T, A>> sourceResultHandlerConsumer) {
        return this.closer.withLifecycleCheck(() -> {
            MuleFrameworkUtils.assertExtensionModelLoader(this.muleFramework, extensionName);
            DietSourceCreationCommand request = new DietSourceCreationCommand(this.muleFramework);
            command.accept(request);
            DietSourceHandlerAdapter sourceHandler = new DietSourceHandlerAdapter(this.extensionsClient.createSource(extensionName, request.getSourceName(), h -> this.closer.withLifecycleCheck(sourceResultHandlerConsumer::accept, new DietSourceResultHandlerAdapter(h)), request::parameterize));
            this.sourceHandlerRegistry.registerSourceHandler(sourceHandler);
            return sourceHandler;
        });
    }

    public void close() {
        this.closer.close(this.sourceHandlerRegistry::disposeAllSourceHandlers);
    }
}

