/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.service;

import com.mulesoft.mule.framework.api.dependency.DependencyResolutionException;
import com.mulesoft.mule.framework.api.dependency.DependencyResolver;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mule.framework.internal.builder.service.MuleFrameworkServiceConfigurerBuilder;
import org.mule.framework.internal.service.SharedServiceLifecycleProxyInvocationHandler;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.deployment.meta.MuleServiceContractModel;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactoryProvider;
import org.mule.runtime.module.service.api.artifact.ServiceDescriptor;
import org.mule.runtime.module.service.api.discoverer.MuleServiceModelLoader;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.ServiceDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleFrameworkServiceDiscoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleFrameworkServiceDiscoverer.class);
    static Map<String, ClassLoaderConfiguration> classLoaderEntryByGroupArtifact = new HashMap<String, ClassLoaderConfiguration>();
    private final ServiceClassLoaderFactory serviceClassLoaderFactory;
    private final Properties servicesVersions;
    private final ArtifactClassLoader containerClassLoader;
    private final DependencyResolver dependencyResolver;
    private final ServiceRegistry registry;
    private final MuleVersion muleVersion;
    private final boolean toolingServicesEnabled;
    private final boolean oAuthServiceEnabled;

    public MuleFrameworkServiceDiscoverer(ServiceClassLoaderFactory serviceClassLoaderFactory, ArtifactClassLoader containerClassLoader, DependencyResolver dependencyResolver, ServiceRegistry registry, MuleVersion muleVersion, boolean toolingServicesEnabled, boolean oAuthServiceEnabled) throws IOException {
        this.serviceClassLoaderFactory = serviceClassLoaderFactory;
        this.servicesVersions = new Properties();
        this.servicesVersions.load(MuleFrameworkServiceConfigurerBuilder.class.getResourceAsStream("/services-versions.properties"));
        this.containerClassLoader = containerClassLoader;
        this.dependencyResolver = dependencyResolver;
        this.registry = registry;
        this.muleVersion = muleVersion;
        this.toolingServicesEnabled = toolingServicesEnabled;
        this.oAuthServiceEnabled = oAuthServiceEnabled;
    }

    public <S extends Service> S createService(Class<S> serviceClass, String groupId, String artifactId, String serviceName, String minMuleVersion) {
        if (this.serviceNotPresentInCurrentMuleVersion(minMuleVersion)) {
            return null;
        }
        return this.createService(serviceClass, groupId, artifactId, serviceName);
    }

    public <S extends Service> S createService(Class<S> serviceClass, String groupId, String artifactId, String serviceName) {
        return (S)this.registry.getService(serviceClass).orElseGet(() -> this.registerService(serviceClass, groupId, artifactId, serviceName, classLoaderEntryByGroupArtifact.computeIfAbsent(groupId + ":" + artifactId, key -> this.resolveServiceClassLoaderConfiguration(groupId, artifactId, this.servicesVersions.getProperty(artifactId)))));
    }

    public <S extends Service> S createService(Class<S> serviceClass, String groupId, String artifactId, String serviceName, Path explodedServicesDir, String minMuleVersion) {
        if (this.serviceNotPresentInCurrentMuleVersion(minMuleVersion)) {
            return null;
        }
        return this.createService(serviceClass, groupId, artifactId, serviceName, explodedServicesDir);
    }

    public <S extends Service> S createService(Class<S> serviceClass, String groupId, String artifactId, String serviceName, Path explodedServicesDir) {
        return (S)this.registry.getService(serviceClass).orElseGet(() -> this.registerService(serviceClass, groupId, artifactId, serviceName, this.getClassLoaderConfiguration(groupId, artifactId, explodedServicesDir.resolve(artifactId).toFile())));
    }

    private boolean serviceNotPresentInCurrentMuleVersion(String minMuleVersion) {
        return this.muleVersion != null && this.muleVersion.priorTo(minMuleVersion);
    }

    private <S extends Service> S registerService(Class<S> serviceClass, String groupId, String artifactId, String serviceName, ClassLoaderConfiguration serviceClassLoaderConfiguration) {
        ArtifactClassLoader serviceClassLoader;
        LOGGER.debug("Creating classloader for `{}:{}`...", (Object)groupId, (Object)artifactId);
        ServiceDescriptor descriptor = new ServiceDescriptor(serviceName);
        descriptor.setClassLoaderConfiguration(serviceClassLoaderConfiguration);
        try {
            serviceClassLoader = this.serviceClassLoaderFactory.create(serviceName, descriptor, this.containerClassLoader);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        LOGGER.debug("Configuring service for `{}:{}`...", (Object)groupId, (Object)artifactId);
        ServiceProviderDiscoverer serviceProviderDiscoverer = () -> {
            try {
                MuleServiceModel muleServiceModel = MuleServiceModelLoader.loadServiceModel((ClassLoader)serviceClassLoader.getClassLoader());
                ArrayList<ServiceAssembly> assemblies = new ArrayList<ServiceAssembly>();
                List contracts = muleServiceModel.getContracts();
                for (MuleServiceContractModel contract : contracts) {
                    assemblies.add(ServiceAssembly.lazyBuilder().withName(muleServiceModel.getName()).withClassLoader(() -> serviceClassLoader.getClassLoader()).withServiceProvider(() -> MuleServiceModelLoader.instantiateServiceProvider((MuleServiceContractModel)contract)).forContract(contract.getContractClassName()).build());
                }
                return assemblies;
            }
            catch (Exception e) {
                throw new ServiceResolutionError("Exception discovering service `" + serviceName + "`", (Throwable)e);
            }
        };
        ServiceDiscoverer serviceDiscoverer = ServiceDiscoverer.create((ServiceProviderDiscoverer)serviceProviderDiscoverer, (ServiceRegistry)this.registry, (service, assembly) -> this.wrapService(serviceClassLoader, (Service)service, (ServiceAssembly)assembly));
        try {
            serviceDiscoverer.discoverServices();
        }
        catch (ServiceResolutionError e) {
            throw new IllegalArgumentException(e);
        }
        return (S)((Service)this.registry.getService(serviceClass).get());
    }

    private Service wrapService(ArtifactClassLoader serviceClassLoader, Service service, ServiceAssembly assembly) {
        return (Service)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{assembly.getServiceContract(), Startable.class, Stoppable.class}, (InvocationHandler)((Object)new SharedServiceLifecycleProxyInvocationHandler(this.registry, assembly.getServiceContract(), serviceClassLoader, service)));
    }

    private ClassLoaderConfiguration resolveServiceClassLoaderConfiguration(String groupId, String artifactId, String version) {
        File serviceExplodedDir;
        BundleDependency resolvedBundleDependency;
        LOGGER.debug("Calculating urls for `{}:{}`...", (Object)groupId, (Object)artifactId);
        try {
            resolvedBundleDependency = this.dependencyResolver.resolveArtifact(new BundleDescriptor.Builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(version).setBaseVersion(version).setType("jar").setClassifier("mule-service").build());
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Couldn't create BundleDescriptor for artifact: '" + groupId + ":" + artifactId + "'", e);
        }
        catch (DependencyResolutionException e) {
            throw new IllegalArgumentException("Couldn't resolve dependencies for artifact: '" + groupId + ":" + artifactId + "'", e);
        }
        try {
            serviceExplodedDir = Files.createTempDirectory(artifactId, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't create temporary dir for artifact: '" + groupId + ":" + artifactId + "'", e);
        }
        URI serviceBundleUri = resolvedBundleDependency.getBundleUri();
        try {
            File serviceFile = Paths.get(serviceBundleUri).toFile();
            if (serviceFile.isDirectory()) {
                MuleFrameworkServiceDiscoverer.copyFolder(serviceFile.toPath(), serviceExplodedDir.toPath());
            } else {
                FileUtils.unzip((File)serviceFile, (File)serviceExplodedDir);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't unpack artifact: '" + groupId + ":" + artifactId + "'", e);
        }
        return this.getClassLoaderConfiguration(groupId, artifactId, serviceExplodedDir);
    }

    private ClassLoaderConfiguration getClassLoaderConfiguration(String groupId, String artifactId, File serviceExplodedDir) {
        try {
            return (ClassLoaderConfiguration)ServiceClassLoaderFactoryProvider.serviceClassLoaderConfigurationLoader().load(serviceExplodedDir, Collections.emptyMap(), ArtifactType.SERVICE);
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new IllegalStateException("Couldn't create descriptor for artifact: '" + groupId + ":" + artifactId + "'", e);
        }
    }

    public boolean isToolingServicesEnabled() {
        return this.toolingServicesEnabled;
    }

    public boolean isOAuthServiceEnabled() {
        return this.oAuthServiceEnabled;
    }

    public static void copyFolder(final Path source, final Path target) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.getFileName().toString().startsWith(".")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Files.createDirectories(target.resolve(source.relativize(dir).toString()), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().startsWith(".")) {
                    return FileVisitResult.CONTINUE;
                }
                Files.copy(file, target.resolve(source.relativize(file).toString()), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

