/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.domain;

import com.mulesoft.mule.framework.api.builder.FrameworkDomainConfigurer;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.framework.internal.builder.artifact.DefaultFrameworkRefreshConfigurer;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.builder.artifact.RefreshConfigurerUtils;
import org.mule.framework.internal.builder.domain.AbstractFrameworkDomainFromProjectConfigurer;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderResolver;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;

public class FrameworkDomainRefreshConfigurer
extends AbstractFrameworkDomainFromProjectConfigurer {
    private final FrameworkDeployableArtifact baseFrameworkDeployableArtifact;
    private final DefaultFrameworkRefreshConfigurer frameworkRefreshConfigurer;
    private Path classPathEntry;
    private DeployableProjectModel deployableProjectModel;

    public FrameworkDomainRefreshConfigurer(FrameworkDeployableArtifact baseFrameworkDeployableArtifact, DefaultFrameworkRefreshConfigurer frameworkRefreshConfigurer) {
        this.baseFrameworkDeployableArtifact = baseFrameworkDeployableArtifact;
        this.frameworkRefreshConfigurer = frameworkRefreshConfigurer;
    }

    @Override
    public FrameworkDomainConfigurer withJavaClasses(Path classPathEntry) {
        if (this.classPathEntry != null) {
            throw new IllegalStateException("'classPathEntry' is already set");
        }
        this.classPathEntry = classPathEntry;
        return this;
    }

    @Override
    protected Path getClassPathEntry() {
        return this.classPathEntry;
    }

    @Override
    protected Optional<AstXmlParser> getAstXmlParser() {
        return Optional.of(this.baseFrameworkDeployableArtifact.getMuleXmlParser());
    }

    @Override
    protected PluginClassLoaderResolver getPluginClassLoaderResolver() {
        return (ownerClassLoader, artifactPluginDescriptor) -> this.baseFrameworkDeployableArtifact.getExecutionClassLoader().getArtifactPluginClassLoaders().stream().filter(apcl -> artifactPluginDescriptor.equals(apcl.getArtifactDescriptor())).findAny().map(apcl -> () -> apcl);
    }

    @Override
    public FrameworkDomain configure(ArtifactClassLoaderResolver classLoaderResolver, Map<String, String> deploymentProperties, MavenConfiguration mavenConfiguration) {
        this.withMuleSources(this.frameworkRefreshConfigurer.getConfigResources());
        this.withConfigDocuments(this.frameworkRefreshConfigurer.getXmlConfigDocuments());
        this.withJavaClasses(this.frameworkRefreshConfigurer.getClassPathEntry());
        return super.configure(classLoaderResolver, deploymentProperties, mavenConfiguration);
    }

    @Override
    protected DeployableProjectModel createDeployableProjectModel(MavenConfiguration mavenConfiguration) {
        if (mavenConfiguration != null) {
            throw new IllegalStateException("'mavenConfiguration' not supported for refreshed instances");
        }
        if (this.deployableProjectModel == null) {
            this.deployableProjectModel = RefreshConfigurerUtils.doCreateDeployableProjectModel(this.baseFrameworkDeployableArtifact);
        }
        return this.deployableProjectModel;
    }

    @Override
    protected DomainDescriptor createDomainDescriptor(Map<String, String> deploymentProperties, Path classPathEntry, Set<URL> folderUrls, MavenConfiguration mavenConfiguration) {
        DeployableProjectModel model = this.createDeployableProjectModel(mavenConfiguration);
        folderUrls.addAll(RefreshConfigurerUtils.populateFolderUrls(model, classPathEntry));
        DomainDescriptor baseDomainDescriptor = (DomainDescriptor)this.baseFrameworkDeployableArtifact.getExecutionClassLoader().getArtifactDescriptor();
        DomainDescriptor domainDescriptor = new DomainDescriptor(baseDomainDescriptor.getName(), baseDomainDescriptor.getDeploymentProperties());
        RefreshConfigurerUtils.configureDescriptor(model, (DeployableArtifactDescriptor)domainDescriptor, (DeployableArtifactDescriptor)baseDomainDescriptor);
        return domainDescriptor;
    }
}

