/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.domain;

import com.mulesoft.mule.framework.api.builder.FrameworkDomainConfigurer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.domain.AbstractFrameworkDomainConfigurer;
import org.mule.framework.internal.builder.domain.DefaultFrameworkDomain;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;

public abstract class AbstractFrameworkDomainFromProjectConfigurer
extends AbstractFrameworkDomainConfigurer {
    public FrameworkDomainConfigurer withJavaClasses(Path classPathEntry) {
        throw new UnsupportedOperationException("Not supported when building from a domain project");
    }

    @Override
    protected DomainDescriptor createDomainDescriptor(Map<String, String> deploymentProperties, Path classPathEntry, Set<URL> folderUrls, MavenConfiguration mavenConfiguration) {
        DeployableProjectModel model = this.createDeployableProjectModel(mavenConfiguration);
        model.validate();
        try {
            for (Path resource : model.getResourcesPath()) {
                folderUrls.add(resource.toUri().toURL());
            }
            if (!model.getPackages().isEmpty() && classPathEntry != null) {
                folderUrls.add(classPathEntry.toUri().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return DeployableArtifactDescriptorFactory.defaultArtifactDescriptorFactory().createDomainDescriptor(model, deploymentProperties);
    }

    @Override
    protected DefaultFrameworkDomain getFrameworkDomain(MuleDeployableArtifactClassLoader domainClassLoader, InternalConfigurationsCreationConfigurer configsCreationConfigurer, boolean dslValidations, UnaryOperator<String> propertiesResolver, MavenConfiguration mavenConfiguration) {
        return new DefaultFrameworkDomain(domainClassLoader, Optional.of(this.createDeployableProjectModel(mavenConfiguration)), configsCreationConfigurer, this.getWorkingDirectory(), dslValidations, propertiesResolver, this.getAstXmlParser(), this.getDomainConfigResources(), this.getDomainXmlConfigDocuments(), mavenConfiguration);
    }

    protected Optional<AstXmlParser> getAstXmlParser() {
        return Optional.empty();
    }

    protected abstract DeployableProjectModel createDeployableProjectModel(MavenConfiguration var1);
}

