/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.domain;

import com.google.common.collect.ImmutableList;
import com.mulesoft.mule.framework.api.builder.ConfigurationsCreationConfigurer;
import com.mulesoft.mule.framework.api.builder.FrameworkDomainConfigurer;
import com.mulesoft.mule.framework.api.builder.PropertiesResolverConfigurer;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.mule.framework.internal.builder.application.DefaultPropertiesResolverConfigurer;
import org.mule.framework.internal.builder.configurations.DefaultConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.domain.DefaultFrameworkDomain;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.framework.internal.builder.domain.InternalFrameworkDomainConfigurer;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderResolver;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.w3c.dom.Document;

public abstract class AbstractFrameworkDomainConfigurer
implements InternalFrameworkDomainConfigurer {
    private static final PluginClassLoaderResolver DEFAULT_PLUGIN_CLASSLOADER_RESOLVER = (ownerClassLoader, artifactPluginDescriptor) -> Optional.empty();
    private InternalConfigurationsCreationConfigurer configsCreationConfigurer;
    private final PluginClassLoaderResolver pluginClassLoaderResolver = DEFAULT_PLUGIN_CLASSLOADER_RESOLVER;
    private Path workingDirectory;
    private boolean dslValidations = true;
    private UnaryOperator<String> propertiesResolver;
    private Collection<ConfigResource> domainConfigResources = null;
    private Map<String, Document> domainXmlConfigDocuments = null;

    public FrameworkDomainConfigurer withConfigurations() {
        return this.withConfigurations(new DefaultConfigurationsCreationConfigurer(), null);
    }

    public FrameworkDomainConfigurer withConfigurations(Consumer<ConfigurationsCreationConfigurer> configurer) {
        return this.withConfigurations(new DefaultConfigurationsCreationConfigurer(), configurer);
    }

    private FrameworkDomainConfigurer withConfigurations(InternalConfigurationsCreationConfigurer configsCreationConfigurer, Consumer<ConfigurationsCreationConfigurer> configurer) {
        if (this.configsCreationConfigurer != null) {
            throw new IllegalStateException("Configurations creation has already been configured");
        }
        this.configsCreationConfigurer = configsCreationConfigurer;
        if (configurer != null) {
            configurer.accept(this.configsCreationConfigurer);
            this.validateConfigurer(this.configsCreationConfigurer);
        }
        return this;
    }

    public FrameworkDomainConfigurer withWorkingDirectory(Path workingDirectory) {
        if (workingDirectory == null) {
            throw new IllegalArgumentException("'workingDirectory' cannot be null");
        }
        if (!workingDirectory.toFile().exists() || !workingDirectory.toFile().isDirectory()) {
            throw new IllegalArgumentException("'workingDirectory' (" + workingDirectory.toString() + ") must be an existing folder");
        }
        if (this.workingDirectory != null) {
            throw new IllegalStateException("'workingDirectory' have already been set");
        }
        this.workingDirectory = workingDirectory;
        return this;
    }

    protected Optional<Path> getWorkingDirectory() {
        return Optional.ofNullable(this.workingDirectory);
    }

    public FrameworkDomainConfigurer disableDslValidations() {
        this.dslValidations = false;
        return this;
    }

    public FrameworkDomainConfigurer withPropertiesResolver(Consumer<PropertiesResolverConfigurer> configurer) {
        if (this.propertiesResolver != null) {
            throw new IllegalStateException("'propertiesResolver' has already been configured");
        }
        DefaultPropertiesResolverConfigurer propertiesResolverConfigurer = new DefaultPropertiesResolverConfigurer();
        configurer.accept(propertiesResolverConfigurer);
        this.propertiesResolver = propertiesResolverConfigurer.getPropertiesResolver();
        return this;
    }

    public FrameworkDomainConfigurer withMuleSources(Collection<ConfigResource> domainConfigResources) {
        if (this.domainConfigResources != null) {
            throw new IllegalStateException("`domainConfigResources` have already been set");
        }
        this.domainConfigResources = domainConfigResources;
        return this;
    }

    public FrameworkDomainConfigurer withConfigDocuments(Map<String, Document> domainXmlConfigDocuments) {
        if (this.domainXmlConfigDocuments != null) {
            throw new IllegalStateException("`domainXmlConfigDocuments` have already been set");
        }
        this.domainXmlConfigDocuments = domainXmlConfigDocuments;
        return this;
    }

    protected void validateConfigurer(InternalConfigurationsCreationConfigurer configsCreationConfigurer) {
    }

    protected final Collection<ConfigResource> getDomainConfigResources() {
        return this.domainConfigResources;
    }

    protected final Map<String, Document> getDomainXmlConfigDocuments() {
        return this.domainXmlConfigDocuments;
    }

    @Override
    public FrameworkDomain configure(ArtifactClassLoaderResolver classLoaderResolver, Map<String, String> deploymentProperties, MavenConfiguration mavenConfiguration) {
        MuleDeployableArtifactClassLoader domainClassLoader = this.createDomainClassLoader(classLoaderResolver, deploymentProperties, mavenConfiguration);
        return this.getFrameworkDomain(domainClassLoader, this.configsCreationConfigurer, this.dslValidations, this.propertiesResolver, mavenConfiguration);
    }

    protected DefaultFrameworkDomain getFrameworkDomain(MuleDeployableArtifactClassLoader domainClassLoader, InternalConfigurationsCreationConfigurer configsCreationConfigurer, boolean dslValidations, UnaryOperator<String> propertiesResolver, MavenConfiguration mavenConfiguration) {
        return new DefaultFrameworkDomain(domainClassLoader, Optional.empty(), configsCreationConfigurer, this.getWorkingDirectory(), dslValidations, propertiesResolver, Optional.empty(), this.getDomainConfigResources(), this.getDomainXmlConfigDocuments(), mavenConfiguration);
    }

    private MuleDeployableArtifactClassLoader createDomainClassLoader(ArtifactClassLoaderResolver classLoaderResolver, Map<String, String> deploymentProperties, MavenConfiguration mavenConfiguration) {
        HashSet<URL> folderUrls = new HashSet<URL>();
        return classLoaderResolver.createDomainClassLoader(this.createDomainDescriptor(deploymentProperties, this.getClassPathEntry(), folderUrls, mavenConfiguration), this.getPluginClassLoaderResolver(), (List)ImmutableList.copyOf(folderUrls));
    }

    protected Path getClassPathEntry() {
        return null;
    }

    protected PluginClassLoaderResolver getPluginClassLoaderResolver() {
        return this.pluginClassLoaderResolver;
    }

    protected abstract DomainDescriptor createDomainDescriptor(Map<String, String> var1, Path var2, Set<URL> var3, MavenConfiguration var4);
}

