/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.artifact;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.serialization.ArtifactAstDeserializer;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PackagedDeployableArtifactWrapper
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackagedDeployableArtifactWrapper.class);
    private final File packagedDeployableArtifactFile;
    private File workDir;

    protected PackagedDeployableArtifactWrapper(File packagedDeployableArtifactFile, String artifactTypeLabel) {
        this.packagedDeployableArtifactFile = !packagedDeployableArtifactFile.isDirectory() ? this.unzipDeployableArtifact(packagedDeployableArtifactFile, artifactTypeLabel) : packagedDeployableArtifactFile;
    }

    private File unzipDeployableArtifact(File artifactFile, String artifactTypeLabel) {
        String workDirPrefix = UUID.randomUUID().toString();
        try {
            this.workDir = Files.createTempDirectory(workDirPrefix, new FileAttribute[0]).toFile();
            File domainLocation = new File(this.workDir, artifactFile.getName() + UUID.randomUUID());
            try (FileInputStream domainJarContent = new FileInputStream(artifactFile);){
                org.mule.runtime.core.api.util.FileUtils.unzip((InputStream)domainJarContent, (File)domainLocation, (boolean)false, (boolean)false);
            }
            return domainLocation;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Error while unzipping packaged %s. Unable to create work directory with prefix '%s'", artifactTypeLabel, workDirPrefix), e);
        }
    }

    public Optional<ArtifactAst> loadSerializedAst(Set<ExtensionModel> extensionModels, boolean forceConfigsParse) {
        block9: {
            if (!forceConfigsParse) {
                ArtifactAstDeserializer astDeserializer = new ArtifactAstSerializerProvider().getDeserializer(true);
                File serializedAstFile = new File(this.getFile(), "META-INF/mule-artifact/artifact.ast");
                Map extensionsByName = extensionModels.stream().collect(Collectors.toMap(ExtensionModel::getName, UnaryOperator.identity()));
                if (serializedAstFile.exists()) {
                    Optional<ArtifactAst> optional;
                    BufferedInputStream artifactAstInputStream = new BufferedInputStream(new FileInputStream(serializedAstFile));
                    try {
                        optional = Optional.of(astDeserializer.deserialize((InputStream)artifactAstInputStream, extensionsByName::get));
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                ((InputStream)artifactAstInputStream).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Error deserializing artifactAst present in artifact. Falling back to config parse.\nError: {}", (Object)e);
                            if (!LOGGER.isDebugEnabled()) break block9;
                            LOGGER.debug("Excetion was: ", (Throwable)e);
                        }
                    }
                    ((InputStream)artifactAstInputStream).close();
                    return optional;
                }
            }
        }
        return Optional.empty();
    }

    public void dispose() {
        if (this.workDir != null) {
            FileUtils.deleteQuietly((File)this.workDir);
        }
    }

    public File getFile() {
        return this.packagedDeployableArtifactFile;
    }
}

