/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.application;

import com.mulesoft.mule.framework.api.builder.FrameworkApplicationConfigurer;
import com.mulesoft.mule.framework.api.dependency.DependencyResolver;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.framework.internal.builder.application.AbstractFrameworkApplicationFromProjectConfigurer;
import org.mule.framework.internal.builder.application.FrameworkApplication;
import org.mule.framework.internal.builder.artifact.DefaultFrameworkRefreshConfigurer;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.builder.artifact.RefreshConfigurerUtils;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderResolver;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;

public class FrameworkApplicationRefreshConfigurer
extends AbstractFrameworkApplicationFromProjectConfigurer {
    private final FrameworkDeployableArtifact baseFrameworkDeployableArtifact;
    private final DefaultFrameworkRefreshConfigurer frameworkRefreshConfigurer;
    private Path classPathEntry;
    private DeployableProjectModel deployableProjectModel;

    public FrameworkApplicationRefreshConfigurer(FrameworkDeployableArtifact baseFrameworkDeployableArtifact, DefaultFrameworkRefreshConfigurer frameworkRefreshConfigurer) {
        this.baseFrameworkDeployableArtifact = baseFrameworkDeployableArtifact;
        this.frameworkRefreshConfigurer = frameworkRefreshConfigurer;
    }

    @Override
    public FrameworkApplicationConfigurer withJavaClasses(Path classPathEntry) {
        if (this.classPathEntry != null) {
            throw new IllegalStateException("'classPathEntry' is already set");
        }
        this.classPathEntry = classPathEntry;
        return this;
    }

    @Override
    protected Path getClassPathEntry() {
        return this.classPathEntry;
    }

    @Override
    protected Optional<AstXmlParser> getAstXmlParser() {
        return Optional.of(this.baseFrameworkDeployableArtifact.getMuleXmlParser());
    }

    @Override
    protected PluginClassLoaderResolver getPluginClassLoaderResolver() {
        return (ownerClassLoader, artifactPluginDescriptor) -> this.baseFrameworkDeployableArtifact.getExecutionClassLoader().getArtifactPluginClassLoaders().stream().filter(apcl -> artifactPluginDescriptor.equals(apcl.getArtifactDescriptor())).findAny().map(apcl -> () -> apcl);
    }

    @Override
    public FrameworkApplication configure(ArtifactClassLoaderResolver classLoaderResolver, Supplier<DependencyResolver> dependencyResolver, Map<String, String> deploymentProperties, MavenConfiguration mavenConfiguration) {
        this.withMuleSources(this.frameworkRefreshConfigurer.getConfigResources());
        this.withConfigDocuments(this.frameworkRefreshConfigurer.getXmlConfigDocuments());
        this.withJavaClasses(this.frameworkRefreshConfigurer.getClassPathEntry());
        return super.configure(classLoaderResolver, dependencyResolver, deploymentProperties, mavenConfiguration);
    }

    @Override
    protected DeployableProjectModel createDeployableProjectModel(MavenConfiguration mavenConfiguration) {
        if (mavenConfiguration != null) {
            throw new IllegalStateException("'mavenConfiguration' not supported for refreshed instances");
        }
        if (this.deployableProjectModel == null) {
            this.deployableProjectModel = RefreshConfigurerUtils.doCreateDeployableProjectModel(this.baseFrameworkDeployableArtifact);
        }
        return this.deployableProjectModel;
    }

    @Override
    protected ApplicationDescriptor createApplicationDescriptor(Supplier<DependencyResolver> dependencyResolver, Map<String, String> deploymentProperties, Path classPathEntry, Set<URL> folderUrls, MavenConfiguration mavenConfiguration) {
        DeployableProjectModel model = this.createDeployableProjectModel(mavenConfiguration);
        folderUrls.addAll(RefreshConfigurerUtils.populateFolderUrls(model, classPathEntry));
        ApplicationDescriptor baseApplicationDescriptor = (ApplicationDescriptor)this.baseFrameworkDeployableArtifact.getExecutionClassLoader().getArtifactDescriptor();
        ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(baseApplicationDescriptor.getName(), baseApplicationDescriptor.getDeploymentProperties());
        applicationDescriptor.setAppProperties(baseApplicationDescriptor.getAppProperties());
        applicationDescriptor.setDomainName(baseApplicationDescriptor.getDomainName());
        applicationDescriptor.setEncoding(baseApplicationDescriptor.getEncoding());
        RefreshConfigurerUtils.configureDescriptor(model, (DeployableArtifactDescriptor)applicationDescriptor, (DeployableArtifactDescriptor)baseApplicationDescriptor);
        return applicationDescriptor;
    }
}

