/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.application;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.mule.framework.internal.builder.application.FrameworkApplication;
import org.mule.framework.internal.builder.artifact.DefaultFrameworkDeployableArtifact;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.xml.parser.ParsingPropertyResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.w3c.dom.Document;

public class DefaultFrameworkApplication
extends DefaultFrameworkDeployableArtifact<ApplicationDescriptor>
implements FrameworkApplication {
    private final MuleDeployableArtifactClassLoader applicationClassLoader;
    private final Optional<FrameworkDomain> domain;

    public DefaultFrameworkApplication(MuleDeployableArtifactClassLoader applicationClassLoader, Optional<DeployableProjectModel> deployableProjectModel, InternalConfigurationsCreationConfigurer configsCreationConfigurer, Optional<FrameworkDomain> domain, Optional<Path> workingDirectory, boolean dslValidations, UnaryOperator<String> propertiesResolver, Optional<AstXmlParser> astXmlParser, Collection<ConfigResource> appConfigResources, Map<String, Document> appXmlConfigDocuments, MavenConfiguration mavenConfiguration) {
        super(applicationClassLoader, deployableProjectModel, configsCreationConfigurer, workingDirectory, dslValidations, propertiesResolver, astXmlParser, appConfigResources, appXmlConfigDocuments, mavenConfiguration);
        this.applicationClassLoader = applicationClassLoader;
        this.domain = domain;
    }

    @Override
    public MuleDeployableArtifactClassLoader getClassLoader() {
        return this.applicationClassLoader;
    }

    @Override
    public MuleDeployableArtifactClassLoader getExecutionClassLoader() {
        return (MuleDeployableArtifactClassLoader)this.applicationClassLoader.getParent();
    }

    @Override
    protected AstXmlParser doCreateMuleXmlParser(Set<ExtensionModel> extensions, boolean disableXmlValidations, ParsingPropertyResolver propertyResolver) {
        AstXmlParser.Builder builder = AstXmlParser.builder().withPropertyResolver(propertyResolver).withExtensionModels(extensions).withArtifactType(ArtifactType.APPLICATION).withParentArtifact(this.domain.map(d -> d.getArtifactAst()).orElse(MuleAstUtils.emptyArtifact()));
        if (disableXmlValidations) {
            builder.withSchemaValidationsDisabled();
        }
        return builder.build();
    }

    @Override
    public Optional<Collection<ComponentAst>> getConfigurationsAsts() {
        Collection domainConfigs = this.domain.flatMap(FrameworkDeployableArtifact::getConfigurationsAsts).orElse(Collections.emptySet());
        HashSet configs = new HashSet();
        configs.addAll(domainConfigs);
        super.getConfigurationsAsts().ifPresent(configs::addAll);
        return Optional.of(configs);
    }

    @Override
    public org.mule.runtime.api.artifact.ArtifactType getArtifactType() {
        return ArtifactType.APPLICATION.getActualType();
    }
}

