/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.application;

import com.mulesoft.mule.framework.api.builder.FrameworkApplicationConfigurer;
import com.mulesoft.mule.framework.api.builder.PluginBuilder;
import com.mulesoft.mule.framework.api.dependency.DependencyResolver;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.mule.framework.internal.builder.application.AbstractFrameworkApplicationConfigurer;
import org.mule.framework.internal.builder.application.DefaultFrameworkApplication;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;

public abstract class AbstractFrameworkApplicationFromProjectConfigurer
extends AbstractFrameworkApplicationConfigurer {
    public FrameworkApplicationConfigurer withResources(List<Path> resources) {
        throw new UnsupportedOperationException("Not supported when building from an application project");
    }

    public FrameworkApplicationConfigurer withJavaClasses(Path classPathEntry) {
        throw new UnsupportedOperationException("Not supported when building from an application project");
    }

    public PluginBuilder withPlugin(String groupId, String artifactId, String version) {
        throw new UnsupportedOperationException("Not supported when building from an application project");
    }

    @Override
    protected ApplicationDescriptor createApplicationDescriptor(Supplier<DependencyResolver> dependencyResolver, Map<String, String> deploymentProperties, Path classPathEntry, Set<URL> folderUrls, MavenConfiguration mavenConfiguration) {
        DeployableProjectModel model = this.createDeployableProjectModel(mavenConfiguration);
        try {
            for (Path resource : model.getResourcesPath()) {
                folderUrls.add(resource.toUri().toURL());
            }
            if (!model.getPackages().isEmpty() && classPathEntry != null) {
                folderUrls.add(classPathEntry.toUri().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return DeployableArtifactDescriptorFactory.defaultArtifactDescriptorFactory().createApplicationDescriptor(model, deploymentProperties, this.getDomainDescriptorResolver());
    }

    @Override
    protected DefaultFrameworkApplication getFrameworkApplication(MuleDeployableArtifactClassLoader applicationClassLoader, InternalConfigurationsCreationConfigurer configsCreationConfigurer, boolean dslValidations, UnaryOperator<String> propertiesResolver, MavenConfiguration mavenConfiguration) {
        return new DefaultFrameworkApplication(applicationClassLoader, Optional.of(this.createDeployableProjectModel(mavenConfiguration)), configsCreationConfigurer, this.getDomainFramework().map(dFwk -> (FrameworkDomain)dFwk.getFrameworkDeployableArtifact()), this.getWorkingDirectory(), dslValidations, propertiesResolver, this.getAstXmlParser(), this.getAppConfigResources(), this.getAppXmlConfigDocuments(), mavenConfiguration);
    }

    protected Optional<AstXmlParser> getAstXmlParser() {
        return Optional.empty();
    }

    protected abstract DeployableProjectModel createDeployableProjectModel(MavenConfiguration var1);
}

