/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.application;

import com.google.common.collect.ImmutableList;
import com.mulesoft.mule.framework.api.MuleFramework;
import com.mulesoft.mule.framework.api.builder.ConfigurationsCreationConfigurer;
import com.mulesoft.mule.framework.api.builder.FrameworkApplicationConfigurer;
import com.mulesoft.mule.framework.api.builder.PropertiesResolverConfigurer;
import com.mulesoft.mule.framework.api.dependency.DependencyResolver;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.mule.framework.internal.DietMuleFrameworkStaticAnalysis;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.builder.application.DefaultFrameworkApplication;
import org.mule.framework.internal.builder.application.DefaultPropertiesResolverConfigurer;
import org.mule.framework.internal.builder.application.FrameworkApplication;
import org.mule.framework.internal.builder.application.InternalFrameworkApplicationConfigurer;
import org.mule.framework.internal.builder.configurations.DefaultConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.framework.internal.util.DependenciesUtils;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorCreator;
import org.mule.runtime.module.artifact.activation.api.descriptor.DomainDescriptorResolutionException;
import org.mule.runtime.module.artifact.activation.api.descriptor.DomainDescriptorResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderResolver;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.w3c.dom.Document;

public abstract class AbstractFrameworkApplicationConfigurer
implements InternalFrameworkApplicationConfigurer {
    private static final PluginClassLoaderResolver DEFAULT_PLUGIN_CLASSLOADER_RESOLVER = (ownerClassLoader, artifactPluginDescriptor) -> Optional.empty();
    private DomainDescriptorResolver domainDescriptorResolver = DomainDescriptorResolver.noDomainDescriptorResolver();
    private ApplicationDescriptor applicationDescriptor;
    private InternalConfigurationsCreationConfigurer configsCreationConfigurer;
    private final PluginClassLoaderResolver pluginClassLoaderResolver = DEFAULT_PLUGIN_CLASSLOADER_RESOLVER;
    private Path workingDirectory;
    private boolean dslValidations = true;
    private UnaryOperator<String> propertiesResolver;
    private Collection<ConfigResource> appConfigResources = null;
    private Map<String, Document> appXmlConfigDocuments = null;

    public FrameworkApplicationConfigurer withConfigurations() {
        return this.withConfigurations(new DefaultConfigurationsCreationConfigurer(), null);
    }

    public FrameworkApplicationConfigurer withConfigurations(Consumer<ConfigurationsCreationConfigurer> configurer) {
        return this.withConfigurations(new DefaultConfigurationsCreationConfigurer(), configurer);
    }

    private FrameworkApplicationConfigurer withConfigurations(InternalConfigurationsCreationConfigurer configsCreationConfigurer, Consumer<ConfigurationsCreationConfigurer> configurer) {
        if (this.configsCreationConfigurer != null) {
            throw new IllegalStateException("Configurations creation has already been configured");
        }
        this.configsCreationConfigurer = configsCreationConfigurer;
        if (configurer != null) {
            configurer.accept(this.configsCreationConfigurer);
            this.validateConfigurer(this.configsCreationConfigurer);
        }
        return this;
    }

    public FrameworkApplicationConfigurer withWorkingDirectory(Path workingDirectory) {
        if (workingDirectory == null) {
            throw new IllegalArgumentException("'workingDirectory' cannot be null");
        }
        if (!workingDirectory.toFile().exists() || !workingDirectory.toFile().isDirectory()) {
            throw new IllegalArgumentException("'workingDirectory' (" + workingDirectory.toString() + ") must be an existing folder");
        }
        if (this.workingDirectory != null) {
            throw new IllegalStateException("'workingDirectory' have already been set");
        }
        this.workingDirectory = workingDirectory;
        return this;
    }

    protected Optional<Path> getWorkingDirectory() {
        return Optional.ofNullable(this.workingDirectory);
    }

    public FrameworkApplicationConfigurer disableDslValidations() {
        this.dslValidations = false;
        return this;
    }

    public FrameworkApplicationConfigurer withPropertiesResolver(Consumer<PropertiesResolverConfigurer> configurer) {
        if (this.propertiesResolver != null) {
            throw new IllegalStateException("'propertiesResolver' has already been configured");
        }
        DefaultPropertiesResolverConfigurer propertiesResolverConfigurer = new DefaultPropertiesResolverConfigurer();
        configurer.accept(propertiesResolverConfigurer);
        this.propertiesResolver = propertiesResolverConfigurer.getPropertiesResolver();
        return this;
    }

    public FrameworkApplicationConfigurer withMuleSources(Collection<ConfigResource> appConfigResources) {
        if (this.appConfigResources != null) {
            throw new IllegalStateException("`appConfigResources` have already been set");
        }
        this.appConfigResources = appConfigResources;
        return this;
    }

    public FrameworkApplicationConfigurer withConfigDocuments(Map<String, Document> appXmlConfigDocuments) {
        if (this.appXmlConfigDocuments != null) {
            throw new IllegalStateException("`appXmlConfigDocuments` have already been set");
        }
        this.appXmlConfigDocuments = appXmlConfigDocuments;
        return this;
    }

    protected void validateConfigurer(InternalConfigurationsCreationConfigurer configsCreationConfigurer) {
    }

    public FrameworkApplicationConfigurer withDomain(Function<BundleDescriptor, MuleFramework> domainResolver) {
        if (domainResolver == null) {
            throw new IllegalArgumentException("'domainResolver' cannot be null");
        }
        if (this.domainDescriptorResolver != DomainDescriptorResolver.noDomainDescriptorResolver()) {
            throw new IllegalStateException("'domainResolver' is already set");
        }
        this.domainDescriptorResolver = new MuleFrameworkDomainDescriptorResolver(domainResolver);
        return this;
    }

    @Override
    public final Optional<InternalMuleFramework> getDomainFramework() {
        if (!this.domainDescriptorResolver.equals(DomainDescriptorResolver.noDomainDescriptorResolver())) {
            if (!this.appDependsOnDomain(this.applicationDescriptor) && this.getDomainFwk().isPresent()) {
                throw new IllegalStateException("'withDomain' resolved a domain, but application does not require one.");
            }
            if (this.appDependsOnDomain(this.applicationDescriptor) && !this.getDomainFwk().isPresent()) {
                throw new IllegalStateException("'withDomain' did not resolve a domain, but application requires one.");
            }
        }
        Optional<InternalMuleFramework> domainFwk = this.getDomainFwk().map(InternalMuleFramework.class::cast);
        domainFwk.filter(fwk -> !(fwk instanceof DietMuleFrameworkStaticAnalysis)).ifPresent(InternalMuleFramework::assertStarted);
        return domainFwk;
    }

    protected final boolean appDependsOnDomain(ApplicationDescriptor applicationDescriptor) {
        return applicationDescriptor.getDomainName() != null && !applicationDescriptor.getDomainName().equals("default") || applicationDescriptor.getDomainDescriptor().isPresent();
    }

    protected final Collection<ConfigResource> getAppConfigResources() {
        return this.appConfigResources;
    }

    protected final Map<String, Document> getAppXmlConfigDocuments() {
        return this.appXmlConfigDocuments;
    }

    protected DomainDescriptorResolver getDomainDescriptorResolver() {
        return this.domainDescriptorResolver;
    }

    @Override
    public FrameworkApplication configure(ArtifactClassLoaderResolver classLoaderResolver, Supplier<DependencyResolver> dependencyResolver, Map<String, String> deploymentProperties, MavenConfiguration mavenConfiguration) {
        MuleDeployableArtifactClassLoader applicationClassLoader = this.createApplicationClassLoader(classLoaderResolver, dependencyResolver, deploymentProperties, mavenConfiguration);
        return this.getFrameworkApplication(applicationClassLoader, this.configsCreationConfigurer, this.dslValidations, this.propertiesResolver, mavenConfiguration);
    }

    protected DefaultFrameworkApplication getFrameworkApplication(MuleDeployableArtifactClassLoader applicationClassLoader, InternalConfigurationsCreationConfigurer configsCreationConfigurer, boolean dslValidations, UnaryOperator<String> propertiesResolver, MavenConfiguration mavenConfiguration) {
        return new DefaultFrameworkApplication(applicationClassLoader, Optional.empty(), configsCreationConfigurer, this.getDomainFramework().map(dFwk -> (FrameworkDomain)dFwk.getFrameworkDeployableArtifact()), this.getWorkingDirectory(), dslValidations, propertiesResolver, Optional.empty(), this.getAppConfigResources(), this.getAppXmlConfigDocuments(), mavenConfiguration);
    }

    private MuleDeployableArtifactClassLoader createApplicationClassLoader(ArtifactClassLoaderResolver classLoaderResolver, Supplier<DependencyResolver> dependencyResolver, Map<String, String> deploymentProperties, MavenConfiguration mavenConfiguration) {
        HashSet<URL> folderUrls = new HashSet<URL>();
        this.applicationDescriptor = this.createApplicationDescriptor(dependencyResolver, deploymentProperties, this.getClassPathEntry(), folderUrls, mavenConfiguration);
        return classLoaderResolver.createApplicationClassLoader(this.applicationDescriptor, this.getPluginClassLoaderResolver(), (List)ImmutableList.copyOf(folderUrls));
    }

    protected Path getClassPathEntry() {
        return null;
    }

    protected PluginClassLoaderResolver getPluginClassLoaderResolver() {
        return this.pluginClassLoaderResolver;
    }

    protected abstract ApplicationDescriptor createApplicationDescriptor(Supplier<DependencyResolver> var1, Map<String, String> var2, Path var3, Set<URL> var4, MavenConfiguration var5);

    private Optional<MuleFramework> getDomainFwk() {
        if (this.domainDescriptorResolver instanceof MuleFrameworkDomainDescriptorResolver) {
            return Optional.ofNullable(((MuleFrameworkDomainDescriptorResolver)this.domainDescriptorResolver).getDomainFwk());
        }
        return Optional.empty();
    }

    private static class MuleFrameworkDomainDescriptorResolver
    implements DomainDescriptorResolver {
        private final Function<BundleDescriptor, MuleFramework> domainMuleFrameworkResolver;
        private MuleFramework domainFwk;

        public MuleFrameworkDomainDescriptorResolver(Function<BundleDescriptor, MuleFramework> domainMuleFrameworkResolver) {
            this.domainMuleFrameworkResolver = domainMuleFrameworkResolver;
        }

        public DomainDescriptor resolve(String name, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor bundleDescriptor) throws DomainDescriptorResolutionException {
            if ((name == null || name.equals("default")) && bundleDescriptor == null) {
                return null;
            }
            this.domainFwk = this.domainMuleFrameworkResolver.apply(DependenciesUtils.muleToMavenDescriptor(bundleDescriptor));
            DomainDescriptor domainDescriptor = (DomainDescriptor)DeployableArtifactDescriptorCreator.domainDescriptorCreator().create(name != null ? name : bundleDescriptor.getArtifactId());
            domainDescriptor.setBundleDescriptor(bundleDescriptor);
            return domainDescriptor;
        }

        public MuleFramework getDomainFwk() {
            return this.domainFwk;
        }
    }
}

