/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal;

import com.mulesoft.mule.framework.api.execution.MuleExecutionFramework;
import com.mulesoft.mule.framework.api.extension.config.ConfigurationHandler;
import com.mulesoft.mule.framework.api.extension.config.fluent.ConfigurationCreationCommand;
import com.mulesoft.mule.framework.api.tooling.MuleToolingFramework;
import com.mulesoft.mule.framework.api.tooling.type.resolution.MetadataStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.mule.framework.internal.AbstractMuleFramework;
import org.mule.framework.internal.DietMuleFrameworkConfigurations;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.extension.config.ConfigCreationWorkaroundUtils;
import org.mule.framework.internal.extension.config.ConfigurationHandlerRegistry;
import org.mule.framework.internal.extension.config.DietConfigurationHandler;
import org.mule.framework.internal.extension.config.InternalConfigurationHandler;
import org.mule.framework.internal.extension.config.fluent.DietConfigurationCreationCommand;
import org.mule.framework.internal.tooling.DietToolingFramework;
import org.mule.framework.internal.tooling.metadata.DietConfigurationMetadataCacheIdGenerator;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.apikit.metadata.api.MetadataService;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.metadata.api.cache.ComponentParameterizationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.ComponentParameterizationMetadataCacheIdGeneratorFactory;
import org.mule.runtime.metadata.api.cache.ConfigurationMetadataCacheIdGenerator;
import org.mule.runtime.module.extension.api.runtime.config.ConfigurationProviderFactory;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;
import org.mule.runtime.module.service.api.manager.ServiceManager;

public class DietMuleFrameworkTooling
extends AbstractMuleFramework {
    private static final String TOOLING_ONLY_MESSAGE_TEMPLATE = "This Mule Framework is meant for using a Mule %ss' tooling operations only";
    private final ServiceManager serviceManager;
    private final FrameworkDeployableArtifact frameworkDeployableArtifact;
    private final Optional<InternalMuleFramework> parentMuleFramework;
    private final MuleContext muleContext;
    private final boolean startMuleContext;
    private final DietToolingFramework toolingFramework;
    private final ConfigurationHandlerRegistry configurationHandlerRegistry;
    private final ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory;
    private final ConfigurationProviderFactory configurationProviderFactory;
    private final Map<String, DslSyntaxResolver> syntaxResolvers = new ConcurrentHashMap<String, DslSyntaxResolver>();
    private final Registry registry;
    private final LazyValue<ConnectionManager> connectionManager;
    private final LazyValue<MetadataService> apiKitMetadataService;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final MetadataStorage metadataStorage;
    private final Optional<DietMuleFrameworkConfigurations> configsManager;
    private final DietConfigurationMetadataCacheIdGenerator configIdGenerator = new DietConfigurationMetadataCacheIdGenerator();
    private final ComponentParameterizationMetadataCacheIdGenerator idGenerator = new ComponentParameterizationMetadataCacheIdGeneratorFactory().create((ConfigurationMetadataCacheIdGenerator)this.configIdGenerator);
    private boolean refreshed;

    public DietMuleFrameworkTooling(MuleContext muleContext, boolean startMuleContext, Registry registry, ServiceManager serviceManager, Set<ExtensionModel> extensionModels, FrameworkDeployableArtifact frameworkDeployableArtifact, Optional<InternalMuleFramework> parentMuleFramework, ExpressionLanguageMetadataService expressionLanguageMetadataService, MetadataStorage metadataStorage, Optional<DietMuleFrameworkConfigurations> configsManager) {
        super(frameworkDeployableArtifact, extensionModels);
        this.serviceManager = serviceManager;
        this.frameworkDeployableArtifact = frameworkDeployableArtifact;
        this.parentMuleFramework = parentMuleFramework;
        this.muleContext = muleContext;
        this.startMuleContext = startMuleContext;
        this.registry = registry;
        this.configurationHandlerRegistry = this.lookup(ConfigurationHandlerRegistry.class);
        this.extensionDesignTimeResolversFactory = this.lookup(ExtensionDesignTimeResolversFactory.class);
        this.configurationProviderFactory = this.lookup(ConfigurationProviderFactory.class);
        this.connectionManager = this.lazyLookup(ConnectionManager.class);
        this.apiKitMetadataService = this.lazyLookup(MetadataService.class);
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.toolingFramework = new DietToolingFramework(this);
        this.metadataStorage = metadataStorage;
        this.configsManager = configsManager;
        frameworkDeployableArtifact.getConfigurationsAsts().map(ArrayList::new).ifPresent(this.configIdGenerator::addConfigurations);
    }

    public ConfigurationHandler createExtensionConfiguration(String extensionName, String configModelName, Consumer<ConfigurationCreationCommand> command) {
        ExtensionModel extensionModel = MuleFrameworkUtils.getExtensionModel(this, extensionName);
        ConfigurationModel configurationModel = (ConfigurationModel)extensionModel.getConfigurationModel(configModelName).orElseThrow(() -> new IllegalArgumentException(String.format("Extension '%s' does not have a config model with name '%s'", extensionName, configModelName)));
        ConfigurationProvider configurationProvider = (ConfigurationProvider)ClassUtils.withContextClassLoader((ClassLoader)this.getClassLoader(extensionModel), () -> {
            DietConfigurationCreationCommand request = new DietConfigurationCreationCommand(extensionModel, configurationModel, this);
            command.accept(request);
            this.configIdGenerator.registerConfiguration(request);
            return ConfigCreationWorkaroundUtils.createConfigurationProvider(extensionModel, request, this.extensionDesignTimeResolversFactory, this.muleContext, this.configurationProviderFactory, this.getDslSyntaxResolver(extensionModel), this.getClassLoader(extensionModel));
        });
        this.muleContext.getExtensionManager().registerConfigurationProvider(configurationProvider);
        DietConfigurationHandler handler = new DietConfigurationHandler(configurationProvider, (CheckedConsumer<InternalConfigurationHandler>)((CheckedConsumer)this::dispose));
        this.configurationHandlerRegistry.registerConfigurationHandler(handler);
        return handler;
    }

    private void dispose(InternalConfigurationHandler handler) {
        this.configIdGenerator.unregisterConfiguration(handler.getName());
        this.configurationHandlerRegistry.unregisterConfigurationHandler(handler);
        this.muleContext.getExtensionManager().unregisterConfigurationProvider(handler.getConfigurationProvider());
    }

    public MuleExecutionFramework getExecutionFramework() {
        throw new UnsupportedOperationException(String.format(TOOLING_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    public MuleToolingFramework getToolingFramework() {
        this.assertStarted();
        return this.toolingFramework;
    }

    @Override
    public ExpressionManager getExpressionManager() {
        this.assertStarted();
        return this.muleContext.getExpressionManager();
    }

    @Override
    public void start() throws MuleException {
        if (this.startMuleContext) {
            this.muleContext.start();
        }
    }

    @Override
    public void assertStarted() throws IllegalStateException {
        if (this.refreshed) {
            throw new IllegalStateException("Mule Framework was used as base for a new one. Use the refreshed instance");
        }
        if (!this.muleContext.isStarted()) {
            throw new IllegalStateException("Mule Framework is not started (" + this.muleContext.getLifecycleManager().getCurrentPhase() + ")");
        }
        this.parentMuleFramework.ifPresent(InternalMuleFramework::assertStarted);
    }

    @Override
    public Collection<ComponentAst> getConfigurations() {
        return Collections.emptyList();
    }

    @Override
    public void close() throws Exception {
        if (!this.isRefreshed()) {
            this.configurationHandlerRegistry.closeAllConfigs();
            this.toolingFramework.close();
            this.muleContext.stop();
            this.muleContext.dispose();
            if (!this.frameworkDeployableArtifact.getWorkingDirectory().isPresent()) {
                FileUtils.deleteDirectory((File)new File(this.muleContext.getConfiguration().getWorkingDirectory()));
            }
            this.serviceManager.stop();
            this.frameworkDeployableArtifact.dispose();
        }
    }

    public void markAsRefreshed() {
        this.refreshed = true;
    }

    protected boolean isRefreshed() {
        return this.refreshed;
    }

    public DslSyntaxResolver getDslSyntaxResolver(ExtensionModel extensionModel) {
        return this.syntaxResolvers.computeIfAbsent(extensionModel.getName(), name -> DslSyntaxResolver.getDefault((ExtensionModel)extensionModel, (DslResolvingContext)this.getDslResolvingContext()));
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return (ConnectionManager)this.connectionManager.get();
    }

    @Override
    public ExtensionsClient getExtensionsClient() {
        throw new UnsupportedOperationException(String.format(TOOLING_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    @Override
    public ConfigurationProperties getConfigurationProperties() {
        return this.frameworkDeployableArtifact.getConfigurationProperties();
    }

    @Override
    public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
        return this.expressionLanguageMetadataService;
    }

    @Override
    public MetadataService getApiKitMetadataService() {
        return (MetadataService)this.apiKitMetadataService.get();
    }

    @Override
    public ClassLoader getExecutionClassLoader() {
        return this.muleContext.getExecutionClassLoader();
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public ExtensionDesignTimeResolversFactory getExtensionDesignTimeResolversFactory() {
        return this.extensionDesignTimeResolversFactory;
    }

    @Override
    public MetadataStorage getMetadataStorage() {
        return this.metadataStorage;
    }

    @Override
    public ComponentParameterizationMetadataCacheIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public ConfigurationMetadataCacheIdGenerator getConfigIdGenerator() {
        return this.configIdGenerator;
    }

    @Override
    public boolean isRegistered(ConfigurationHandler configurationHandler) {
        return this.configurationHandlerRegistry.isRegistered(configurationHandler);
    }

    @Override
    public FrameworkDeployableArtifact getFrameworkDeployableArtifact() {
        return this.frameworkDeployableArtifact;
    }

    @Override
    public Optional<ConfigurationHandler> getConfigurationHandler(String name) {
        if (this.getConfigsManager().isPresent()) {
            return this.getConfigsManager().get().getConfigurationHandler(name, this.configurationHandlerRegistry::getConfigurationHandler, this::createExtensionConfiguration);
        }
        return this.configurationHandlerRegistry.getConfigurationHandler(name);
    }

    public TypedValue evaluateExpression(String expression, BindingContext bindingContext) {
        throw new UnsupportedOperationException(String.format(TOOLING_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    private <T> T lookup(Class<T> clazz) {
        return this.registry.lookupByType(clazz).orElse(null);
    }

    protected <T> LazyValue<T> lazyLookup(Class<T> clazz) {
        return new LazyValue(() -> this.lookup(clazz));
    }

    private ClassLoader getClassLoader(ExtensionModel extensionModel) {
        return (ClassLoader)ExtensionModelUtils.getExtensionClassLoader((ExtensionModel)extensionModel).orElse(this.frameworkDeployableArtifact.getExecutionClassLoader());
    }

    public Optional<DietMuleFrameworkConfigurations> getConfigsManager() {
        return this.configsManager;
    }
}

