/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.util;

import com.mulesoft.mule.framework.api.MuleFramework;
import com.mulesoft.mule.framework.api.exception.IllegalParametersException;
import com.mulesoft.mule.framework.api.extension.config.ConfigurationHandler;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.mule.framework.internal.extension.config.InternalConfigurationHandler;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MuleFrameworkUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleFrameworkUtils.class);

    private MuleFrameworkUtils() {
    }

    public static ExtensionModel getExtensionModel(MuleFramework muleFramework, String extensionName) {
        return (ExtensionModel)muleFramework.getExtensionModel(extensionName).orElseThrow(() -> new IllegalParametersException(String.format("Extension '%s' is not registered in this framework instance", extensionName)));
    }

    public static Optional<ExtensionModel> getExtensionModelOptional(MuleFramework muleFramework, String extensionName) {
        return muleFramework.getExtensionModels().stream().filter(em -> em.getName().equals(extensionName)).findAny();
    }

    public static Optional<ExtensionModel> getExtensionModelOptional(MuleFramework muleFramework, ArtifactCoordinates artifactCoordinates) {
        return muleFramework.getExtensionModels().stream().filter(em -> em.getArtifactCoordinates().isPresent()).filter(em -> ((ArtifactCoordinates)em.getArtifactCoordinates().get()).getGroupId().equals(artifactCoordinates.getGroupId()) && ((ArtifactCoordinates)em.getArtifactCoordinates().get()).getArtifactId().equals(artifactCoordinates.getArtifactId())).findAny();
    }

    public static void assertExtensionModelLoader(MuleFramework muleFramework, String extensionName) {
        MuleFrameworkUtils.getExtensionModel(muleFramework, extensionName);
    }

    public static void stopAndDispose(Object object) {
        if (object == null) {
            return;
        }
        try {
            LifecycleUtils.stopIfNeeded((Object)object);
        }
        catch (MuleException e) {
            LOGGER.error("Exception trying to stop " + object, (Throwable)e);
        }
        finally {
            LifecycleUtils.disposeIfNeeded((Object)object, (Logger)LOGGER);
        }
    }

    public static InternalConfigurationHandler asInternal(ConfigurationHandler configurationHandler) {
        if (configurationHandler instanceof InternalConfigurationHandler) {
            return (InternalConfigurationHandler)configurationHandler;
        }
        throw new IllegalArgumentException("Invalid ConfigurationHandler implementation");
    }

    public static <C> Optional<ConnectionProvider<C>> getConnectionProvider(Optional<ConfigurationHandler> optionalConfigurationHandler) {
        CoreEvent nullEvent = CoreEvent.nullEvent();
        try {
            Optional<ConnectionProvider<C>> optional = optionalConfigurationHandler.flatMap(arg_0 -> MuleFrameworkUtils.lambda$getConnectionProvider$4((Event)nullEvent, arg_0));
            return optional;
        }
        finally {
            ((BaseEventContext)nullEvent.getContext()).success();
        }
    }

    public static <C> Supplier<C> connectionSupplier(Optional<ConfigurationHandler> configurationHandler) {
        return () -> {
            Optional connectionProvider = MuleFrameworkUtils.getConnectionProvider(configurationHandler);
            return connectionProvider.isPresent() ? connectionProvider.get().connect() : null;
        };
    }

    public static Supplier<Object> configSupplier(Optional<ConfigurationHandler> optionalConfigurationHandler) {
        return () -> {
            CoreEvent nullEvent = CoreEvent.nullEvent();
            try {
                Object var2_2 = optionalConfigurationHandler.map(arg_0 -> MuleFrameworkUtils.lambda$configSupplier$6((Event)nullEvent, arg_0)).orElse(null);
                return var2_2;
            }
            finally {
                ((BaseEventContext)nullEvent.getContext()).success();
            }
        };
    }

    public static Optional<ConfigurationInstance> resolveConfiguration(Optional<ConfigurationHandler> configurationHandler) {
        CoreEvent event = CoreEvent.nullEvent();
        try {
            Optional<ConfigurationInstance> optional = configurationHandler.map(h -> MuleFrameworkUtils.asInternal(h).getConfigurationProvider().get((Event)event));
            return optional;
        }
        finally {
            ((BaseEventContext)event.getContext()).success();
        }
    }

    public static boolean mustOverrideArtifact(BundleDescriptor currentDependency, BundleDescriptor newDependency) {
        DefaultArtifactVersion newDependencyVersion;
        DefaultArtifactVersion currentDependencyVersion = new DefaultArtifactVersion(currentDependency.getVersion());
        if (MuleFrameworkUtils.isGreaterVersion(currentDependencyVersion, newDependencyVersion = new DefaultArtifactVersion(newDependency.getVersion()))) {
            if (currentDependencyVersion.getMajorVersion() != newDependencyVersion.getMajorVersion()) {
                throw new IllegalArgumentException("Cannot override major version of a dependency. Dependency: " + currentDependency.getArtifactId() + ". Current version: " + currentDependency.getVersion() + ". New version: " + newDependency.getVersion());
            }
            return true;
        }
        return false;
    }

    private static boolean isGreaterVersion(DefaultArtifactVersion actualDependency, DefaultArtifactVersion transitiveDependency) {
        return actualDependency.compareTo((ArtifactVersion)transitiveDependency) < 0;
    }

    public static ClassLoader getClassLoader(ExtensionModel extensionModel) {
        return extensionModel.getModelProperty(ClassLoaderModelProperty.class).map(ClassLoaderModelProperty::getClassLoader).orElse(Thread.currentThread().getContextClassLoader());
    }

    public static boolean isMuleSdkEnabled() {
        return Boolean.getBoolean("mule.experimental.enableMuleSdk");
    }

    private static /* synthetic */ Object lambda$configSupplier$6(Event nullEvent, ConfigurationHandler configurationHandler) {
        return MuleFrameworkUtils.asInternal(configurationHandler).getConfigurationProvider().get(nullEvent).getValue();
    }

    private static /* synthetic */ Optional lambda$getConnectionProvider$4(Event nullEvent, ConfigurationHandler configurationHandler) {
        return MuleFrameworkUtils.asInternal(configurationHandler).getConfigurationProvider().get(nullEvent).getConnectionProvider();
    }
}

