/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.utils;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.mule.framework.internal.tooling.type.propagation.cfg.TypePropagationCFGVisitor;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.module.soapkit.metadata.api.Metadata;
import org.mule.module.soapkit.metadata.api.Notifier;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.apikit.metadata.api.MetadataBuilder;
import org.mule.runtime.apikit.metadata.api.MetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.core.api.management.stats.ApiKitStatsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKitUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiKitUtils.class);
    private static final String RESOURCE_PLACEHOLDER = "resource::";
    private static final ComponentIdentifier APIKIT_CONFIG = ComponentIdentifier.builder().name("config").namespace("apikit").build();
    private static final ComponentIdentifier SOAPKIT_CONFIG = ComponentIdentifier.builder().name("config").namespace("apikit-soap").build();

    private ApiKitUtils() {
    }

    public static Optional<org.mule.runtime.apikit.metadata.api.Metadata> buildApiKitMetadataResolver(ArtifactAst application, MetadataService apikitMetadataService, ClassLoader cl) {
        if (!ApiKitUtils.applicationHasApiKit(application)) {
            return Optional.empty();
        }
        ApiKitPropagationNotifier notifier = new ApiKitPropagationNotifier();
        MetadataBuilder apikitMetadataResolverBuilder = apikitMetadataService.getApikitMetadataBuilder().withApplicationModel(application).withResourceLoader(resource -> {
            if (resource.startsWith(RESOURCE_PLACEHOLDER)) {
                resource = resource.substring(RESOURCE_PLACEHOLDER.length());
            }
            try {
                URL url = cl.getResource(resource);
                return url != null ? url.toURI() : cl.getResource("api/" + resource).toURI();
            }
            catch (URISyntaxException e) {
                LOGGER.debug("URL for resource {} could not be resolved", (Object)resource);
                return null;
            }
        }).withNotifier((org.mule.runtime.apikit.metadata.api.Notifier)notifier);
        if (notifier.error != null) {
            return Optional.empty();
        }
        return Optional.ofNullable(apikitMetadataResolverBuilder.build());
    }

    public static Optional<Metadata> buildSoapKitMetadataResolver(ArtifactAst application, ClassLoader cl) {
        if (!ApiKitUtils.applicationHasSoapKit(application)) {
            return Optional.empty();
        }
        ApiKitPropagationNotifier notifier = new ApiKitPropagationNotifier();
        Metadata.Builder builder = new Metadata.Builder().withApplicationModel(application).withResourceLoader(resource -> {
            URL url;
            if (resource.startsWith(RESOURCE_PLACEHOLDER)) {
                resource = resource.substring(RESOURCE_PLACEHOLDER.length());
            }
            return (url = cl.getResource(resource)) != null ? url : cl.getResource("api/" + resource);
        }).withNotifier((Notifier)notifier);
        if (notifier.error != null) {
            return Optional.empty();
        }
        return Optional.ofNullable(builder.build());
    }

    public static void setInitialPayloadOfApiKitFlow(org.mule.runtime.apikit.metadata.api.Metadata apikitMetadata, String flowName, TypePropagationCFGVisitor visitor) {
        if (!ApiKitStatsUtils.isApiKitFlow((String)flowName)) {
            return;
        }
        apikitMetadata.getMetadataForFlow(flowName).flatMap(type -> type.getParameters().stream().filter(param -> param.getName().equals("inputMetadata")).findFirst()).map(FunctionParameter::getType).map(type -> (MuleEventMetadataType)type).ifPresent(type -> visitor.initialMessage(type.getMessageType()));
    }

    public static Optional<MuleEventMetadataType> apiKitFlowReturnType(org.mule.runtime.apikit.metadata.api.Metadata apikitMetadata, String flowName) {
        if (!ApiKitStatsUtils.isApiKitFlow((String)flowName)) {
            return Optional.empty();
        }
        return apikitMetadata.getMetadataForFlow(flowName).flatMap(FunctionType::getReturnType).map(MuleEventMetadataType.class::cast);
    }

    public static void setInitialPayloadOfSoapKitFlow(Metadata soapKitMetadata, String flowName, TypePropagationCFGVisitor visitor) {
        if (!ApiKitStatsUtils.isApiKitFlow((String)flowName)) {
            return;
        }
        soapKitMetadata.getMetadataForFlow(flowName).flatMap(type -> type.getParameters().stream().filter(param -> param.getName().equals("inputMetadata")).findFirst()).map(FunctionParameter::getType).map(type -> (MuleEventMetadataType)type).ifPresent(type -> visitor.initialMessage(type.getMessageType()));
    }

    public static Optional<MuleEventMetadataType> soapKitFlowReturnType(Metadata soapKitMetadata, String flowName) {
        if (!ApiKitStatsUtils.isApiKitFlow((String)flowName)) {
            return Optional.empty();
        }
        return soapKitMetadata.getMetadataForFlow(flowName).flatMap(FunctionType::getReturnType).map(MuleEventMetadataType.class::cast);
    }

    private static boolean applicationHasApiKit(ArtifactAst ast) {
        return ast.topLevelComponentsStream().anyMatch(componentAst -> componentAst.getIdentifier().equals(APIKIT_CONFIG));
    }

    private static boolean applicationHasSoapKit(ArtifactAst ast) {
        return ast.topLevelComponentsStream().anyMatch(componentAst -> componentAst.getIdentifier().equals(SOAPKIT_CONFIG));
    }

    private static final class ApiKitPropagationNotifier
    implements org.mule.runtime.apikit.metadata.api.Notifier,
    Notifier {
        public String error = null;

        private ApiKitPropagationNotifier() {
        }

        public void error(String message) {
            this.error = message;
        }

        public void warn(String message) {
        }

        public void info(String message) {
        }

        public void debug(String message) {
        }
    }
}

