/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.mule.framework.internal.tooling.type.override.declarations.model.TypeOverrideDeclaration;
import org.mule.framework.internal.tooling.type.override.enrichment.model.DefaultTypeOverrideKey;
import org.mule.framework.internal.tooling.type.override.enrichment.model.TypeOverridesRepository;
import org.mule.framework.internal.tooling.type.propagation.cfg.ErrorHandlingTracker;
import org.mule.framework.internal.tooling.type.propagation.cfg.MessageTracker;
import org.mule.framework.internal.tooling.type.propagation.cfg.VariablesTracker;
import org.mule.framework.internal.tooling.type.propagation.utils.ModelsUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.nested.ChainExecutionOccurrence;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;

public class TypePropagationStatus {
    private static final MetadataType ANY_TYPE = new BaseTypeBuilder(MetadataFormat.JAVA).anyType().build();
    private static final MetadataType VOID_TYPE = new BaseTypeBuilder(MetadataFormat.JAVA).voidType().build();
    private final MessageTracker messageTracker = new MessageTracker(ANY_TYPE, VOID_TYPE);
    private final VariablesTracker variablesTracker = new VariablesTracker();
    private final ErrorHandlingTracker errorHandlingTracker;
    private final Map<ComponentLocation, MessageMetadataType> inputs = new HashMap<ComponentLocation, MessageMetadataType>();
    private final Map<ComponentLocation, Map<String, MetadataType>> inputVariables = new HashMap<ComponentLocation, Map<String, MetadataType>>();
    private final Map<ComponentLocation, MetadataResult<HasOutputModel>> outputs = new HashMap<ComponentLocation, MetadataResult<HasOutputModel>>();
    private final Map<ComponentLocation, Map<String, MetadataType>> outputVariables = new HashMap<ComponentLocation, Map<String, MetadataType>>();
    private final Map<ComponentLocation, MessageMetadataType> chainInputs = new HashMap<ComponentLocation, MessageMetadataType>();
    private final Map<ComponentLocation, Pair<MetadataType, MetadataType>> chainOutputs = new HashMap<ComponentLocation, Pair<MetadataType, MetadataType>>();
    private final Map<ComponentLocation, Map<String, MetadataType>> chainInputVariables = new HashMap<ComponentLocation, Map<String, MetadataType>>();
    private final Map<ComponentLocation, Map<String, MetadataType>> chainOutputVariables = new HashMap<ComponentLocation, Map<String, MetadataType>>();
    private final Set<ComponentLocation> interruptedChains = new HashSet<ComponentLocation>();
    private final Map<ComponentLocation, MetadataType> errorTypes = new HashMap<ComponentLocation, MetadataType>();
    private final Map<ComponentLocation, ConnectableComponentModel> updatedModels = new HashMap<ComponentLocation, ConnectableComponentModel>();
    private final Map<ComponentLocation, Set<String>> modifiedBindings = new HashMap<ComponentLocation, Set<String>>();
    private final Set<ComponentLocation> manuallyTraversed = new HashSet<ComponentLocation>();
    private final TypeOverridesRepository typeOverridesRepository;
    private boolean success;

    public TypePropagationStatus(TypeOverridesRepository typeOverridesRepository, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this.typeOverridesRepository = typeOverridesRepository;
        this.success = true;
        this.errorHandlingTracker = new ErrorHandlingTracker(expressionLanguageMetadataService);
    }

    public void saveChainInputsMetadata(ComponentAst componentAst, MessageMetadataType inputMetadata) {
        TypeOverrideDeclaration typeOverride;
        MessageMetadataType inputMetadataToSave = inputMetadata;
        Optional<TypeOverrideDeclaration> optionalOverride = this.typeOverridesRepository.getTypeOverride(new DefaultTypeOverrideKey(componentAst));
        if (optionalOverride.isPresent() && ((typeOverride = optionalOverride.get()).getInputAttributesType().isPresent() || typeOverride.getInputPayloadType().isPresent())) {
            MessageMetadataTypeBuilder builder = MessageMetadataType.builder();
            inputMetadata.getAttributesType().ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)builder).attributes(arg_0));
            inputMetadata.getPayloadType().ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)builder).payload(arg_0));
            typeOverride.getInputAttributesType().ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)builder).attributes(arg_0));
            typeOverride.getInputPayloadType().ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)builder).payload(arg_0));
            inputMetadataToSave = builder.build();
        }
        this.chainInputs.put(componentAst.getLocation(), inputMetadataToSave);
    }

    public void saveInputsMetadata(ComponentAst componentAst) {
        this.typeOverridesRepository.getTypeOverride(new DefaultTypeOverrideKey(componentAst)).ifPresent(typeOverride -> {
            typeOverride.getInputAttributesType().ifPresent(this.messageTracker::setAttributes);
            typeOverride.getInputPayloadType().ifPresent(this.messageTracker::setPayload);
        });
        this.inputs.put(componentAst.getLocation(), this.messageTracker.getFullMessageType());
    }

    public void saveChainOutputsMetadata(ComponentAst componentAst) {
        this.typeOverridesRepository.getTypeOverride(new DefaultTypeOverrideKey(componentAst)).ifPresent(typeOverride -> {
            typeOverride.getOutputAttributesType().ifPresent(this.messageTracker::setAttributes);
            typeOverride.getOutputPayloadType().ifPresent(this.messageTracker::setPayload);
        });
        this.chainOutputs.put(componentAst.getLocation(), (Pair<MetadataType, MetadataType>)new Pair((Object)this.messageTracker.getCurrentPayload(), (Object)this.messageTracker.getCurrentAttributes()));
    }

    public void saveOutputsMetadata(ComponentAst componentAst, HasOutputModel outputModel) {
        HasOutputModel actualOutputModel;
        block2: {
            Optional<MetadataType> payloadOptional;
            Optional<MetadataType> attrsOptional;
            block3: {
                actualOutputModel = outputModel;
                Optional<TypeOverrideDeclaration> optionalOverride = this.typeOverridesRepository.getTypeOverride(new DefaultTypeOverrideKey(componentAst));
                if (!optionalOverride.isPresent()) break block2;
                TypeOverrideDeclaration typeOverride = optionalOverride.get();
                attrsOptional = typeOverride.getOutputAttributesType();
                payloadOptional = typeOverride.getOutputPayloadType();
                if (attrsOptional.isPresent()) break block3;
                if (!payloadOptional.isPresent()) break block2;
            }
            attrsOptional.ifPresent(this.messageTracker::setAttributes);
            payloadOptional.ifPresent(this.messageTracker::setPayload);
            actualOutputModel = ModelsUtils.getOverriddenHasOutputModel(outputModel, payloadOptional, attrsOptional);
        }
        this.outputs.put(componentAst.getLocation(), (MetadataResult<HasOutputModel>)MetadataResult.success((Object)actualOutputModel));
    }

    public void saveChainInputVariables(ComponentAst componentAst) {
        this.typeOverridesRepository.getTypeOverride(new DefaultTypeOverrideKey(componentAst)).map(TypeOverrideDeclaration::getOutputVariables).ifPresent(overriddenVariables -> overriddenVariables.forEach(this.variablesTracker::addVariable));
        this.chainInputVariables.put(componentAst.getLocation(), Collections.unmodifiableMap(this.variablesTracker.getCurrentVariables()));
    }

    public void saveChainOutputVariables(ComponentAst componentAst) {
        this.typeOverridesRepository.getTypeOverride(new DefaultTypeOverrideKey(componentAst)).map(TypeOverrideDeclaration::getOutputVariables).ifPresent(overriddenVariables -> overriddenVariables.forEach(this.variablesTracker::addVariable));
        this.chainOutputVariables.put(componentAst.getLocation(), Collections.unmodifiableMap(this.variablesTracker.getCurrentVariables()));
    }

    public void saveInputVariables(ComponentAst componentAst) {
        this.typeOverridesRepository.getTypeOverride(new DefaultTypeOverrideKey(componentAst)).map(TypeOverrideDeclaration::getInputVariables).ifPresent(overriddenVariables -> overriddenVariables.forEach(this.variablesTracker::addVariable));
        this.inputVariables.put(componentAst.getLocation(), Collections.unmodifiableMap(this.variablesTracker.getCurrentVariables()));
    }

    public void saveOutputVariables(ComponentAst componentAst) {
        this.typeOverridesRepository.getTypeOverride(new DefaultTypeOverrideKey(componentAst)).map(TypeOverrideDeclaration::getOutputVariables).ifPresent(overriddenVariables -> overriddenVariables.forEach(this.variablesTracker::addVariable));
        this.outputVariables.put(componentAst.getLocation(), Collections.unmodifiableMap(this.variablesTracker.getCurrentVariables()));
    }

    public void saveOutputsFailure(ComponentAst componentAst, MetadataFailure metadataFailure) {
        this.outputs.put(componentAst.getLocation(), (MetadataResult<HasOutputModel>)MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{metadataFailure}));
        this.success = false;
    }

    public void saveOutputsFailure(ComponentAst componentAst, List<MetadataFailure> metadataFailures) {
        this.outputs.put(componentAst.getLocation(), (MetadataResult<HasOutputModel>)MetadataResult.failure(metadataFailures));
        this.success = false;
    }

    public void clearOutputsFor(ComponentAst componentAst) {
        this.outputs.put(componentAst.getLocation(), null);
    }

    public boolean containsOutputMetadata(ComponentLocation componentLocation) {
        return this.outputs.containsKey(componentLocation);
    }

    public MetadataResult<HasOutputModel> getOutputMetadata(ComponentLocation componentLocation) {
        return this.outputs.get(componentLocation);
    }

    public MessageMetadataType getInputMetadata(ComponentLocation componentLocation) {
        return this.inputs.get(componentLocation);
    }

    public MessageMetadataType getChainInputs(ComponentLocation componentLocation) {
        return this.chainInputs.get(componentLocation);
    }

    public Pair<MetadataType, MetadataType> getChainOutputs(ComponentLocation componentLocation) {
        return this.chainOutputs.get(componentLocation);
    }

    public void addInterruptedChain(ComponentAst componentAst) {
        this.interruptedChains.add(componentAst.getLocation());
    }

    public boolean isInterruptedChain(ComponentLocation componentLocation) {
        return this.interruptedChains.contains(componentLocation);
    }

    public Set<ComponentLocation> getInterruptedChains() {
        return this.interruptedChains;
    }

    public Map<String, MetadataType> getChainInputVariables(ComponentLocation componentLocation) {
        return this.chainInputVariables.get(componentLocation);
    }

    public Map<String, MetadataType> getChainOutputVariables(ComponentLocation componentLocation) {
        return this.chainOutputVariables.get(componentLocation);
    }

    public Map<String, MetadataType> getInputVariables(ComponentLocation componentLocation) {
        return this.inputVariables.getOrDefault(componentLocation, Collections.emptyMap());
    }

    public Map<String, MetadataType> getInputVariablesNoDefault(ComponentLocation componentLocation) {
        return this.inputVariables.get(componentLocation);
    }

    public void saveErrorType(ComponentAst componentAst, MetadataType errorType) {
        this.errorTypes.put(componentAst.getLocation(), errorType);
    }

    public Optional<MetadataType> getErrorType(ComponentLocation componentLocation) {
        return Optional.ofNullable(this.errorTypes.get(componentLocation));
    }

    public Map<String, MetadataType> getOutputVariables(ComponentLocation componentLocation) {
        return this.outputVariables.get(componentLocation);
    }

    public Optional<MetadataType> getErrorBindingType() {
        return this.errorHandlingTracker.getErrorBindingType();
    }

    public void errorHandlerMayBeInvokedWith(ComponentLocation componentLocation, MessageMetadataType messageType, Map<String, MetadataType> variables) {
        this.errorHandlingTracker.errorHandlerMayBeInvokedWith(componentLocation, messageType, variables);
    }

    public MessageMetadataType getInputMessageTypeForErrorHandler(ComponentLocation componentLocation) {
        return this.errorHandlingTracker.getInputMessageTypeForErrorHandler(componentLocation);
    }

    public Map<String, MetadataType> getVariableTypesForErrorHandler(ComponentLocation componentLocation) {
        return this.errorHandlingTracker.getVariableTypesForErrorHandler(componentLocation);
    }

    public void enableErrorBinding() {
        this.errorHandlingTracker.enableErrorBinding();
    }

    public void removeErrorBinding() {
        this.errorHandlingTracker.removeErrorBinding();
    }

    public void saveUpdatedModel(ComponentLocation componentLocation, ConnectableComponentModel operationModel) {
        this.updatedModels.put(componentLocation, operationModel);
    }

    public Map<ComponentLocation, ConnectableComponentModel> getUpdatedModels() {
        return this.updatedModels;
    }

    public void setInitialMessage(MessageMetadataType metadataType) {
        this.messageTracker.setInitialMessage(metadataType);
    }

    public void setInitialPayload(MetadataType payloadType) {
        this.messageTracker.setInitialPayload(payloadType);
    }

    public void setInitialAttributes(MetadataType metadataType) {
        this.messageTracker.setInitialAttributes(metadataType);
    }

    public void setInitialMessage(MetadataType outputType, MetadataType outputAttributesType) {
        this.messageTracker.setInitialMessage(outputType, outputAttributesType);
    }

    public MessageMetadataType getFullMessageType() {
        return this.messageTracker.getFullMessageType();
    }

    public MetadataType getCurrentPayload() {
        return this.messageTracker.getCurrentPayload();
    }

    public MetadataType getCurrentAttributes() {
        return this.messageTracker.getCurrentAttributes();
    }

    public void setMessageTypes(MessageMetadataType inputMetadata) {
        this.messageTracker.setMessageTypes(inputMetadata);
    }

    public void revertCurrentState() {
        this.messageTracker.revertCurrentState();
    }

    public void saveCurrentState() {
        this.messageTracker.saveCurrentState();
    }

    public void setPayload(MetadataType metadataType) {
        this.messageTracker.setPayload(metadataType);
    }

    public void setAttributes(MetadataType metadataType) {
        this.messageTracker.setAttributes(metadataType);
    }

    public Map<String, MetadataType> getCurrentVariables() {
        return this.variablesTracker.getCurrentVariables();
    }

    public void setCurrentVariables(Map<String, MetadataType> variables) {
        this.variablesTracker.setCurrentVariables(variables);
    }

    public void addVariable(String name, MetadataType type) {
        this.variablesTracker.addVariable(name, type);
    }

    public void enterChain() {
        this.variablesTracker.enterChain();
    }

    public void saveCurrentVariables() {
        this.variablesTracker.saveCurrentVariables();
    }

    public void goBackToPreviousVariables() {
        this.variablesTracker.goBackToPreviousVariables();
    }

    public void removeVariable(String name) {
        this.variablesTracker.removeVariable(name);
    }

    public void addVariablesPreComposable(Map<String, MetadataType> variables) {
        this.variablesTracker.addVariablesPreComposable(variables);
    }

    public void combineVariables(List<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>> chainsVariables, BinaryOperator<MetadataType> combinationFunction) {
        this.variablesTracker.combineVariables(chainsVariables, combinationFunction);
    }

    public void combineVariables(List<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>> chainsVariables) {
        this.variablesTracker.combineVariables(chainsVariables);
    }

    public void exitChain() {
        this.variablesTracker.exitChain();
    }

    public void markAsManuallyTraversed(ComponentLocation componentLocation) {
        this.manuallyTraversed.add(componentLocation);
    }

    public boolean isManuallyTraversed(ComponentLocation componentLocation) {
        return this.manuallyTraversed.contains(componentLocation);
    }

    public void setModifiesBinding(ComponentLocation location, String binding) {
        this.modifiedBindings.computeIfAbsent(location, ignored -> new HashSet()).add(binding);
    }

    public boolean modifiesBinding(ComponentLocation location, String binding) {
        return this.modifiedBindings.containsKey(location) && this.modifiedBindings.get(location).contains(binding);
    }

    public boolean wasSuccessfulPropagation() {
        return this.success;
    }
}

