/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.framework.internal.tooling.type.propagation.utils.ExpressionUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.metadata.java.api.handler.DefaultTypeHandlerManagerFactory;
import org.mule.metadata.java.api.handler.TypeHandlerManagerFactory;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class ErrorHandlingTracker {
    private static final MetadataType ANY_TYPE = new BaseTypeBuilder(MetadataFormat.JAVA).anyType().build();
    private static final MetadataType ERROR_TYPE = new JavaTypeLoader(ErrorHandlingTracker.class.getClassLoader(), (TypeHandlerManagerFactory)new DefaultTypeHandlerManagerFactory()).load(Error.class);
    private static final MessageMetadataType DEFAULT_INPUT_MESSAGE = MessageMetadataType.builder().payload(ANY_TYPE).attributes(ANY_TYPE).build();
    private static final Map<String, MetadataType> DEFAULT_INPUT_VARS = Collections.emptyMap();
    private final Map<ComponentLocation, ErrorHandlerInput> errorHandlerInputs = new HashMap<ComponentLocation, ErrorHandlerInput>();
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private Optional<MetadataType> errorType = Optional.empty();

    public ErrorHandlingTracker(ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    }

    public void errorHandlerMayBeInvokedWith(ComponentLocation errorHandlerLocation, MessageMetadataType currentMessageType, Map<String, MetadataType> currentVariableTypes) {
        ErrorHandlerInput currentInput = new ErrorHandlerInput(currentMessageType, currentVariableTypes, this.expressionLanguageMetadataService);
        this.errorHandlerInputs.merge(errorHandlerLocation, currentInput, ErrorHandlerInput::merge);
    }

    public MessageMetadataType getInputMessageTypeForErrorHandler(ComponentLocation errorHandlerLocation) {
        return Optional.ofNullable(this.errorHandlerInputs.get(errorHandlerLocation)).map(ErrorHandlerInput::getMessageType).orElse(DEFAULT_INPUT_MESSAGE);
    }

    public Map<String, MetadataType> getVariableTypesForErrorHandler(ComponentLocation errorHandlerLocation) {
        return Optional.ofNullable(this.errorHandlerInputs.get(errorHandlerLocation)).map(ErrorHandlerInput::getVariableTypes).orElse(DEFAULT_INPUT_VARS);
    }

    public void enableErrorBinding() {
        this.errorType = Optional.of(ERROR_TYPE);
    }

    public void removeErrorBinding() {
        this.errorType = Optional.empty();
    }

    public Optional<MetadataType> getErrorBindingType() {
        return this.errorType;
    }

    private static class ErrorHandlerInput {
        private final MessageMetadataType messageType;
        private final Map<String, MetadataType> variableTypes;
        private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

        private ErrorHandlerInput(MessageMetadataType messageType, Map<String, MetadataType> variableTypes, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
            this.messageType = messageType;
            this.variableTypes = variableTypes;
            this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        }

        public MessageMetadataType getMessageType() {
            return this.messageType;
        }

        public Map<String, MetadataType> getVariableTypes() {
            return this.variableTypes;
        }

        public ErrorHandlerInput merge(ErrorHandlerInput other) {
            return new ErrorHandlerInput(this.mergeMessageTypes(this.messageType, other.messageType), this.mergeVariables(this.variableTypes, other.variableTypes), this.expressionLanguageMetadataService);
        }

        private MessageMetadataType mergeMessageTypes(MessageMetadataType type1, MessageMetadataType type2) {
            MessageMetadataTypeBuilder builder = MessageMetadataType.builder();
            this.mergeTypes(type1.getPayloadType(), type2.getPayloadType()).ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)builder).payload(arg_0));
            this.mergeTypes(type1.getAttributesType(), type2.getAttributesType()).ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)builder).attributes(arg_0));
            return builder.build();
        }

        private Map<String, MetadataType> mergeVariables(Map<String, MetadataType> type1, Map<String, MetadataType> type2) {
            HashSet<String> varsNamesUnion = new HashSet<String>(type1.keySet());
            varsNamesUnion.addAll(type2.keySet());
            return varsNamesUnion.stream().collect(Collectors.toMap(Function.identity(), varName -> this.mergeTypes((MetadataType)type1.get(varName), (MetadataType)type2.get(varName))));
        }

        private Optional<MetadataType> mergeTypes(Optional<MetadataType> type1, Optional<MetadataType> type2) {
            if (type1.isPresent() && type2.isPresent()) {
                return Optional.of(this.mergeTypes(type1.get(), type2.get()));
            }
            if (type1.isPresent() || type2.isPresent()) {
                return Optional.of(ANY_TYPE);
            }
            return Optional.empty();
        }

        private MetadataType mergeTypes(MetadataType type1, MetadataType type2) {
            if (type1 == null || type2 == null || type1.equals(ANY_TYPE) || type2.equals(ANY_TYPE)) {
                return ANY_TYPE;
            }
            if (type1.equals(type2)) {
                return type1;
            }
            ArrayList<String> errors = new ArrayList<String>();
            ExpressionLanguageMetadataService.MessageCallback messageCallback = ExpressionUtils.createMessageCallback(errors);
            if (this.expressionLanguageMetadataService.isAssignable(type1, type2, messageCallback) && errors.isEmpty()) {
                return type2;
            }
            errors.clear();
            if (this.expressionLanguageMetadataService.isAssignable(type2, type1, messageCallback) && errors.isEmpty()) {
                return type1;
            }
            return ANY_TYPE;
        }
    }
}

